/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.op.CastExpr;
import net.xfra.qizxopen.xquery.op.Expression;

public class TreatExpr
extends CastExpr {
    public TreatExpr(Expression expression, Type type) {
        super(expression, type);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "TreatExpr");
        exprDump.display("targetType", this.targetType);
        exprDump.display("expr", this.expr);
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.expr = staticContext.staticCheck(this.expr, 0);
        if (!this.expr.getType().accepts(this.targetType)) {
            staticContext.error(this, "static type of expression [%1] not compatible with %2", this.expr.getType().toString(staticContext), this.targetType.toString(staticContext));
        }
        this.type = this.targetType;
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        Value value = this.expr.eval(focus, evalContext);
        try {
            value = this.targetType.check(value);
        }
        catch (TypeException typeException) {
            evalContext.error((Expression)this, typeException);
        }
        return value;
    }
}

