/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.QNameValue;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NodeConstructor;
import net.xfra.qizxopen.xquery.op.TextLiteral;

public abstract class NamedConstructor
extends NodeConstructor {
    public Expression name;

    public NamedConstructor(Expression expression) {
        this.contents = new Expression[0];
        this.name = expression;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "NamedConstructor");
        exprDump.display("name", this.name);
        exprDump.display("contents", this.contents);
    }

    public Expression staticCheck(StaticContext staticContext) {
        super.staticCheck(staticContext);
        if (this.name != null) {
            this.name = staticContext.staticCheck(this.name, 0);
            if (!Type.QNAME.accepts(this.name.getType()) && !Type.STRING.accepts(this.name.getType())) {
                staticContext.getLog().error(this.name.module, this.name.location, "bad type for constructor name: must be xs:string or xs:QName");
            }
        }
        return this;
    }

    public Expression addTextItem(String string) {
        Expression expression = null;
        TextLiteral textLiteral = null;
        if (this.contents.length > 0 && (expression = this.contents[this.contents.length - 1]) instanceof TextLiteral) {
            textLiteral = (TextLiteral)expression;
            textLiteral.value = textLiteral.value + string;
        } else {
            textLiteral = new TextLiteral(string);
            this.addItem(textLiteral);
        }
        return textLiteral;
    }

    QName evalName(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException {
        Value value = this.name.eval(focus, evalContext);
        if (!value.next()) {
            evalContext.error((Expression)this, "unexpected empty sequence");
        }
        if (Type.QNAME.accepts(this.name.getType())) {
            return ((QNameValue)value).getValue();
        }
        try {
            String string = value.asString();
            String string2 = NSPrefixMapping.extractPrefix(string);
            String string3 = NSPrefixMapping.extractLocalName(string);
            if (string2.length() == 0) {
                return QName.get(Namespace.NONE, string3);
            }
            QName qName = null;
            String string4 = xMLEventReceiver == null ? null : xMLEventReceiver.resolvePrefix(string2);
            qName = string4 != null ? QName.get(string4, string3) : evalContext.getStaticContext().getInScopeNS().expandName(string);
            if (qName == null) {
                evalContext.error((Expression)this, "no namespace found for prefix " + string2);
            }
            return qName;
        }
        catch (Exception exception) {
            evalContext.error((Expression)this, "error converting string to QName: " + exception.getMessage());
            return null;
        }
    }

    String evalContents(Focus focus, EvalContext evalContext) throws XQueryException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.contents.length) {
            Value value = this.contents[n].eval(focus, evalContext);
            if (value.next()) {
                stringBuffer.append(value.asString());
            }
            while (value.next()) {
                stringBuffer.append(' ');
                stringBuffer.append(value.asString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void evalContents(Node node, Focus focus, EvalContext evalContext) throws XQueryException {
        int n = 0;
        while (n < this.contents.length) {
            Value value = this.contents[n].eval(focus, evalContext);
            if (value.next()) {
                node.addText(value.asString());
            }
            while (value.next()) {
                node.addText(" ");
                node.addText(value.asString());
            }
            ++n;
        }
    }
}

