/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.op.Expression;

public class FunctionCall
extends Expression {
    public QName name;
    Expression[] args = new Expression[0];

    public FunctionCall(QName qName) {
        this.name = qName;
    }

    public void addArgument(Expression expression) {
        this.args = Expression.addExpr(this.args, expression);
    }

    public Expression getArgument(int n) {
        return n < 0 || n >= this.args.length ? null : this.args[n];
    }

    public boolean visit(Expression.Visitor visitor) {
        return visitor.examine(this) && visitor.visit(this.args);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "FunctionCall");
        exprDump.display("name", this.name);
    }

    public Expression staticCheck(StaticContext staticContext) {
        FunctionCall functionCall = this;
        int n = 0;
        while (n < this.args.length) {
            this.args[n] = staticContext.staticCheck(this.args[n], 0);
            ++n;
        }
        try {
            Function function = staticContext.functionLookup(this.name);
            if (function == null) {
                staticContext.getLog().error(this.module, this.location, "unknown function '%1'", staticContext.prefixedName(this.name));
                return this;
            }
            return function.staticCheck(staticContext, this.args, this);
        }
        catch (XQueryException xQueryException) {
            staticContext.getLog().error(this.module, this.location, "error on function '%1': " + xQueryException.getMessage(), staticContext.prefixedName(this.name));
            return this;
        }
    }

    public Value eval(Focus focus, EvalContext evalContext) {
        throw new RuntimeException("FunctionCall.eval(" + this.name + ") : should not happen");
    }
}

