/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import java.util.Arrays;
import java.util.Comparator;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.IntegerValue;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.op.AndExpr;
import net.xfra.qizxopen.xquery.op.Comparison;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.ForClause;
import net.xfra.qizxopen.xquery.op.Join;
import net.xfra.qizxopen.xquery.op.LetClause;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.NodeSortExpr;
import net.xfra.qizxopen.xquery.op.OrderSpec;
import net.xfra.qizxopen.xquery.op.ValueNeOp;
import net.xfra.qizxopen.xquery.op.VarClause;
import net.xfra.qizxopen.xquery.op.VarReference;

public class FLWRExpr
extends Expression {
    Expression[] clauses = new Expression[0];
    public Expression where;
    public boolean stableOrder;
    public boolean checked;
    OrderSpec[] orderSpecs;
    public Expression expr;
    static int genId;

    public void addClause(VarClause varClause) {
        this.clauses = Expression.addExpr(this.clauses, varClause);
    }

    public void addClause(VarClause varClause, VarClause varClause2) {
        this.clauses = Expression.addExpr(this.clauses, varClause);
        int n = this.clauses.length;
        while (--n > 0) {
            this.clauses[n] = this.clauses[n - 1];
            if (this.clauses[n] != varClause2) continue;
            this.clauses[n - 1] = varClause;
            break;
        }
    }

    VarClause getClause(int n) {
        return n < 0 || n >= this.clauses.length ? null : (VarClause)this.clauses[n];
    }

    static synchronized int generateId() {
        return ++genId;
    }

    public void addOrderSpec(OrderSpec orderSpec) {
        if (this.orderSpecs == null) {
            this.orderSpecs = new OrderSpec[]{orderSpec};
        } else {
            OrderSpec[] orderSpecArray = this.orderSpecs;
            this.orderSpecs = new OrderSpec[orderSpecArray.length + 1];
            System.arraycopy(orderSpecArray, 0, this.orderSpecs, 0, orderSpecArray.length);
            this.orderSpecs[orderSpecArray.length] = orderSpec;
        }
    }

    OrderSpec getOrderSpec(int n) {
        return n < 0 || this.orderSpecs == null || n >= this.orderSpecs.length ? null : this.orderSpecs[n];
    }

    public boolean visit(Expression.Visitor visitor) {
        return visitor.examine(this) && visitor.visit(this.clauses) && visitor.visit(this.orderSpecs) && this.expr.visit(visitor);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "FLOWER");
        exprDump.display("clauses", this.clauses);
        if (this.where != null) {
            exprDump.display("where", this.where);
        }
        if (this.orderSpecs != null) {
            exprDump.display("orderSpecs", this.orderSpecs);
        }
        exprDump.display("expr", this.expr);
    }

    public Expression staticCheck(StaticContext staticContext) {
        JoinInfo joinInfo;
        LocalVariable localVariable = staticContext.markLocalVariables();
        int n = 0;
        while (n < this.clauses.length) {
            ((VarClause)this.clauses[n]).owner = this;
            staticContext.staticCheck(this.clauses[n], 0);
            ++n;
        }
        if (this.where != null) {
            this.where = staticContext.staticCheck(this.where, 0);
        }
        this.expr = staticContext.staticCheck(this.expr, 0);
        this.type = this.expr.getType().getItemType().star;
        if (this.orderSpecs != null) {
            int n2 = 0;
            while (n2 < this.orderSpecs.length) {
                staticContext.staticCheck(this.orderSpecs[n2], 0);
                ++n2;
            }
        }
        if (this.where != null && (joinInfo = this.joinablePredicate(this.where)) != null) {
            LocalVariable localVariable2;
            this.where = joinInfo.remainder;
            ForClause forClause = (ForClause)joinInfo.innerVar.owner;
            LocalVariable localVariable3 = joinInfo.outerVar;
            while ((localVariable2 = localVariable3.before) != null) {
                if (localVariable2.name == null || this.depends(forClause.expr, localVariable2)) break;
                localVariable3 = localVariable2;
            }
            QName qName = QName.get("#join" + FLWRExpr.generateId());
            LocalVariable localVariable4 = new LocalVariable(qName, Type.WRAPPED_OBJECT, null);
            localVariable4.declareBefore(localVariable3);
            LetClause letClause = new LetClause(qName);
            localVariable4.owner = letClause;
            letClause.varDecl = localVariable4;
            QName qName2 = QName.get("#jtmp");
            LocalVariable localVariable5 = new LocalVariable(qName2, Type.NODE, null);
            localVariable4.addAfter(localVariable5);
            joinInfo.innerExpr.visit(new VarReplacer(joinInfo.innerVar, localVariable5));
            letClause.expr = new Join.Maker(forClause.expr, joinInfo.innerExpr, localVariable5, joinInfo.type);
            VarClause varClause = (VarClause)localVariable3.owner;
            FLWRExpr fLWRExpr = (FLWRExpr)varClause.owner;
            letClause.owner = fLWRExpr;
            fLWRExpr.addClause(letClause, varClause);
            forClause.expr = new Join.GetExpr(joinInfo.outerExpr, localVariable4, joinInfo.comparison);
        }
        staticContext.popLocalVariables(localVariable);
        return this;
    }

    JoinInfo joinablePredicate(Expression expression) {
        if (expression instanceof AndExpr) {
            AndExpr andExpr = (AndExpr)expression;
            int n = andExpr.args.length;
            int n2 = 0;
            while (n2 < n) {
                JoinInfo joinInfo = this.joinablePredicate(andExpr.args[n2]);
                if (joinInfo != null) {
                    if (n == 2) {
                        joinInfo.remainder = andExpr.args[1 - n2];
                    } else {
                        AndExpr andExpr2 = new AndExpr();
                        andExpr2.args = new Expression[n - 1];
                        System.arraycopy(andExpr.args, 0, andExpr2.args, 0, n2);
                        System.arraycopy(andExpr.args, n2 + 1, andExpr2.args, n2, n - n2 - 1);
                        joinInfo.remainder = andExpr2;
                    }
                    return joinInfo;
                }
                ++n2;
            }
            return null;
        }
        if (!(expression instanceof Comparison.Exec)) {
            return null;
        }
        Comparison.Exec exec = (Comparison.Exec)expression;
        Expression expression2 = exec.args[0];
        Expression expression3 = exec.args[1];
        if (expression2 instanceof NodeSortExpr) {
            expression2 = ((NodeSortExpr)expression2).expr;
        }
        if (expression3 instanceof NodeSortExpr) {
            expression3 = ((NodeSortExpr)expression3).expr;
        }
        ForVarCollector forVarCollector = new ForVarCollector();
        expression2.visit(forVarCollector);
        if (forVarCollector.found == null || forVarCollector.found2 != null) {
            return null;
        }
        LocalVariable localVariable = forVarCollector.found;
        forVarCollector.found = null;
        expression3.visit(forVarCollector);
        if (forVarCollector.found == null || forVarCollector.found2 != null) {
            return null;
        }
        LocalVariable localVariable2 = forVarCollector.found;
        if (localVariable == localVariable2 || exec.decision == ValueNeOp.COMP) {
            return null;
        }
        JoinInfo joinInfo = new JoinInfo();
        joinInfo.outerVar = localVariable;
        joinInfo.innerVar = localVariable2;
        joinInfo.outerExpr = expression2;
        joinInfo.innerExpr = expression3;
        LocalVariable localVariable3 = localVariable2;
        while (localVariable3 != null && localVariable3 != localVariable) {
            localVariable3 = localVariable3.before;
        }
        if (localVariable3 == null) {
            exec.args[0] = expression3;
            exec.args[1] = expression2;
            exec.decision = exec.decision.reverse();
            joinInfo.outerVar = localVariable2;
            joinInfo.innerVar = localVariable;
            joinInfo.outerExpr = expression3;
            joinInfo.innerExpr = expression2;
        }
        joinInfo.comparison = exec.decision;
        ItemType itemType = expression2.getType().getItemType();
        ItemType itemType2 = expression3.getType().getItemType();
        if (Type.NUMERIC.isSuperType(itemType) || Type.NUMERIC.isSuperType(itemType2)) {
            joinInfo.type = Type.NUMERIC;
        } else if (Type.STRING.accepts(itemType) && Type.STRING.accepts(itemType2)) {
            joinInfo.type = Type.STRING;
        }
        return joinInfo;
    }

    boolean depends(Expression expression, LocalVariable localVariable) {
        return !expression.visit(new VarDependence(localVariable));
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        GenericValue genericValue;
        VarClause.Sequence sequence = new VarClause.Sequence(focus, evalContext);
        int n = 0;
        while (n < this.clauses.length) {
            genericValue = (VarClause.Sequence)this.clauses[n].eval(focus, evalContext);
            genericValue.setSource(sequence);
            sequence = genericValue;
            ++n;
        }
        if (this.orderSpecs == null) {
            if (this.expr.getType() == Type.INTEGER) {
                return new IntSequence(sequence, focus, evalContext);
            }
            if (this.expr.getType() == Type.STRING) {
                return new StringSequence(sequence, focus, evalContext);
            }
            if (this.expr.getType().getOccurrence() == 0) {
                return new ItemSequence(sequence, focus, evalContext);
            }
        }
        genericValue = new Sequence(sequence, focus, evalContext);
        if (this.orderSpecs != null) {
            return this.sorted(genericValue, focus, evalContext);
        }
        return genericValue;
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        if (this.orderSpecs != null) {
            super.evalAsEvents(xMLEventReceiver, focus, evalContext);
            return;
        }
        VarClause.Sequence sequence = new VarClause.Sequence(focus, evalContext);
        int n = 0;
        while (n < this.clauses.length) {
            VarClause.Sequence sequence2 = (VarClause.Sequence)this.clauses[n].eval(focus, evalContext);
            sequence2.setSource(sequence);
            sequence = sequence2;
            ++n;
        }
        while (sequence.next()) {
            if (this.where != null && !this.where.evalEffectiveBooleanValue(focus, evalContext)) continue;
            evalContext.at(this.expr);
            this.expr.evalAsEvents(xMLEventReceiver, focus, evalContext);
        }
    }

    private ArraySequence sorted(Value value, Focus focus, EvalContext evalContext) throws XQueryException {
        Object[] objectArray = new Object[8];
        int n = 0;
        int n2 = this.orderSpecs.length;
        while (value.next()) {
            Object object;
            Item[] itemArray = new Item[n2 + 1];
            itemArray[0] = value.asItem();
            int n3 = 0;
            while (n3 < n2) {
                object = this.orderSpecs[n3].key.eval(focus, evalContext);
                if (!object.next()) {
                    itemArray[n3 + 1] = null;
                } else {
                    itemArray[n3 + 1] = object.asAtom();
                    if (object.next()) {
                        evalContext.error((Expression)this.orderSpecs[n3], "order key must be atomic");
                    }
                }
                ++n3;
            }
            if (n >= objectArray.length) {
                object = objectArray;
                objectArray = new Object[((Object[])object).length * 2];
                System.arraycopy(object, 0, objectArray, 0, ((Object)object).length);
            }
            objectArray[n++] = itemArray;
        }
        try {
            if (n > 1) {
                Arrays.sort(objectArray, 0, n, new KeyComparison(this.orderSpecs, evalContext.getImplicitTimezone()));
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof XQueryException) {
                throw (XQueryException)runtimeException.getCause();
            }
            throw runtimeException;
        }
        int n4 = n;
        while (--n4 >= 0) {
            Item[] itemArray = (Item[])objectArray[n4];
            objectArray[n4] = itemArray[0];
        }
        return new ArraySequence(objectArray, n);
    }

    static class KeyComparison
    implements Comparator {
        OrderSpec[] orderSpecs;
        int keyCnt;
        int timezone;

        KeyComparison(OrderSpec[] orderSpecArray, int n) {
            this.orderSpecs = orderSpecArray;
            this.keyCnt = orderSpecArray.length;
            this.timezone = n;
        }

        public int compare(Object object, Object object2) {
            try {
                Item[] itemArray = (Item[])object;
                Item[] itemArray2 = (Item[])object2;
                int n = 0;
                int n2 = 1;
                while (n2 <= this.keyCnt) {
                    n = this.orderSpecs[n2 - 1].compare(itemArray[n2], itemArray2[n2], this.timezone);
                    if (n != 0) break;
                    ++n2;
                }
                return n;
            }
            catch (TypeException typeException) {
                throw new RuntimeException(typeException);
            }
        }
    }

    public class StringSequence
    extends StringValue {
        Focus focus;
        EvalContext context;
        Value source;
        String curItem;

        StringSequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
        }

        public Value bornAgain() {
            return new StringSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public String asString() {
            return this.curItem;
        }

        public boolean next() throws XQueryException {
            do {
                if (this.source.next()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.context.at(FLWRExpr.this.expr);
            this.curItem = FLWRExpr.this.expr.evalAsString(this.focus, this.context);
            return true;
        }
    }

    public class IntSequence
    extends IntegerValue {
        Focus focus;
        EvalContext context;
        Value source;
        long curItem;

        IntSequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
        }

        public Value bornAgain() {
            return new IntSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public long asInteger() {
            return this.curItem;
        }

        public boolean next() throws XQueryException {
            do {
                if (this.source.next()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.context.at(FLWRExpr.this.expr);
            this.curItem = FLWRExpr.this.expr.evalAsInteger(this.focus, this.context);
            return true;
        }
    }

    public class ItemSequence
    extends GenericValue {
        Focus focus;
        EvalContext context;
        Value source;

        ItemSequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
        }

        public Value bornAgain() {
            return new ItemSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public boolean next() throws XQueryException {
            do {
                if (this.source.next()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.context.at(FLWRExpr.this.expr);
            this.item = FLWRExpr.this.expr.evalAsItem(this.focus, this.context);
            return true;
        }

        public boolean nextCollection() throws XQueryException {
            do {
                if (this.source.nextCollection()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.item = FLWRExpr.this.expr.evalAsItem(this.focus, this.context);
            return true;
        }
    }

    public class Sequence
    extends GenericValue {
        Focus focus;
        EvalContext context;
        Value source;
        Value current;

        Sequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
            this.current = Value.empty;
        }

        public Value bornAgain() {
            return new Sequence(this.source.bornAgain(), this.focus, this.context);
        }

        public boolean next() throws XQueryException {
            while (true) {
                this.context.at(FLWRExpr.this.expr);
                if (this.current.next()) {
                    this.item = this.current.asItem();
                    return true;
                }
                do {
                    if (this.source.next()) continue;
                    return false;
                } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
                this.current = FLWRExpr.this.expr.eval(this.focus, this.context);
            }
        }
    }

    public static class VarReplacer
    extends Expression.Visitor {
        LocalVariable replaced;
        LocalVariable replacing;

        VarReplacer(LocalVariable localVariable, LocalVariable localVariable2) {
            this.replaced = localVariable;
            this.replacing = localVariable2;
        }

        public boolean examine(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            if (local.decl == this.replaced) {
                local.decl = this.replacing;
                local.name = this.replacing.name;
            }
            return true;
        }
    }

    public static class VarDependence
    extends Expression.Visitor {
        LocalVariable var;

        VarDependence(LocalVariable localVariable) {
            this.var = localVariable;
        }

        public boolean examine(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            return local.decl != this.var;
        }
    }

    public static class ForVarCollector
    extends Expression.Visitor {
        LocalVariable found;
        LocalVariable found2;

        public boolean examine(Expression expression) {
            if (!(expression instanceof VarReference.Local)) {
                return true;
            }
            VarReference.Local local = (VarReference.Local)expression;
            Expression expression2 = local.decl.owner;
            if (!(expression2 instanceof ForClause)) {
                return true;
            }
            if (this.found == null || this.found == local.decl) {
                this.found = local.decl;
                return true;
            }
            this.found2 = local.decl;
            return false;
        }
    }

    public static class JoinInfo {
        LocalVariable outerVar;
        LocalVariable innerVar;
        Expression outerExpr;
        Expression innerExpr;
        Expression remainder;
        Comparison.DecisionMaker comparison;
        Type type;
    }
}

