/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.impl.SequenceType;
import net.xfra.qizxopen.xquery.op.Expression;

public class CastExpr
extends Expression {
    public Expression expr;
    public ItemType targetType;
    protected boolean isOptional;

    public CastExpr(Expression expression, Type type) {
        this.expr = expression;
        this.targetType = type.getItemType();
        this.isOptional = type instanceof SequenceType;
    }

    public boolean visit(Expression.Visitor visitor) {
        return visitor.examine(this) && this.expr.visit(visitor);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "cast as");
        exprDump.display("type", this.targetType);
        exprDump.display("expr", this.expr);
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.expr = staticContext.staticCheck(this.expr, 0);
        this.type = this.targetType;
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        Value value;
        Value value2 = this.expr.eval(focus, evalContext);
        if (!value2.next()) {
            if (!this.isOptional) {
                evalContext.error((Expression)this, "empty sequence cannot be cast to type " + this.targetType);
            } else {
                return Value.empty;
            }
        }
        try {
            value = this.targetType.cast(value2, evalContext);
        }
        catch (TypeException typeException) {
            typeException.setContext(evalContext);
            throw typeException;
        }
        if (value2.next()) {
            evalContext.error((Expression)this, "singleton expected in cast");
        }
        return value;
    }
}

