/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.impl;

import java.math.BigDecimal;
import java.util.HashMap;
import net.xfra.qizxopen.dm.BaseNodeTest;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.Query;
import net.xfra.qizxopen.xquery.SyntaxException;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.DocumentTest;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.NodeType;
import net.xfra.qizxopen.xquery.fn.UserFunction;
import net.xfra.qizxopen.xquery.impl.Lexer;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.impl.PredefinedModule;
import net.xfra.qizxopen.xquery.impl.SequenceType;
import net.xfra.qizxopen.xquery.op.AfterOp;
import net.xfra.qizxopen.xquery.op.AncestorOrSelfStep;
import net.xfra.qizxopen.xquery.op.AncestorStep;
import net.xfra.qizxopen.xquery.op.AndExpr;
import net.xfra.qizxopen.xquery.op.AtomConstructor;
import net.xfra.qizxopen.xquery.op.AttributeConstructor;
import net.xfra.qizxopen.xquery.op.AttributeStep;
import net.xfra.qizxopen.xquery.op.BeforeOp;
import net.xfra.qizxopen.xquery.op.CaseClause;
import net.xfra.qizxopen.xquery.op.CastExpr;
import net.xfra.qizxopen.xquery.op.CastableExpr;
import net.xfra.qizxopen.xquery.op.ChildStep;
import net.xfra.qizxopen.xquery.op.DecimalLiteral;
import net.xfra.qizxopen.xquery.op.DescendantOrSelfStep;
import net.xfra.qizxopen.xquery.op.DescendantStep;
import net.xfra.qizxopen.xquery.op.DivOp;
import net.xfra.qizxopen.xquery.op.DocumentConstructor;
import net.xfra.qizxopen.xquery.op.DoubleLiteral;
import net.xfra.qizxopen.xquery.op.ElementConstructor;
import net.xfra.qizxopen.xquery.op.EqOp;
import net.xfra.qizxopen.xquery.op.ExceptOp;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.FLWRExpr;
import net.xfra.qizxopen.xquery.op.FilterExpr;
import net.xfra.qizxopen.xquery.op.FollowingSiblingStep;
import net.xfra.qizxopen.xquery.op.FollowingStep;
import net.xfra.qizxopen.xquery.op.ForClause;
import net.xfra.qizxopen.xquery.op.FunctionCall;
import net.xfra.qizxopen.xquery.op.GeOp;
import net.xfra.qizxopen.xquery.op.GlobalVariable;
import net.xfra.qizxopen.xquery.op.GtOp;
import net.xfra.qizxopen.xquery.op.IDivOp;
import net.xfra.qizxopen.xquery.op.IfExpr;
import net.xfra.qizxopen.xquery.op.InstanceofExpr;
import net.xfra.qizxopen.xquery.op.IntegerLiteral;
import net.xfra.qizxopen.xquery.op.IntersectOp;
import net.xfra.qizxopen.xquery.op.IsNotOp;
import net.xfra.qizxopen.xquery.op.IsOp;
import net.xfra.qizxopen.xquery.op.LeOp;
import net.xfra.qizxopen.xquery.op.LetClause;
import net.xfra.qizxopen.xquery.op.LtOp;
import net.xfra.qizxopen.xquery.op.MinusOp;
import net.xfra.qizxopen.xquery.op.ModOp;
import net.xfra.qizxopen.xquery.op.MulOp;
import net.xfra.qizxopen.xquery.op.NamedConstructor;
import net.xfra.qizxopen.xquery.op.NamespaceConstructor;
import net.xfra.qizxopen.xquery.op.NeOp;
import net.xfra.qizxopen.xquery.op.NegateOp;
import net.xfra.qizxopen.xquery.op.OrExpr;
import net.xfra.qizxopen.xquery.op.OrderSpec;
import net.xfra.qizxopen.xquery.op.PIConstructor;
import net.xfra.qizxopen.xquery.op.ParentStep;
import net.xfra.qizxopen.xquery.op.PathExpr;
import net.xfra.qizxopen.xquery.op.PlusOp;
import net.xfra.qizxopen.xquery.op.Pragma;
import net.xfra.qizxopen.xquery.op.PrecedingSiblingStep;
import net.xfra.qizxopen.xquery.op.PrecedingStep;
import net.xfra.qizxopen.xquery.op.QNameLiteral;
import net.xfra.qizxopen.xquery.op.QuantifiedExpr;
import net.xfra.qizxopen.xquery.op.RangeExpr;
import net.xfra.qizxopen.xquery.op.ReverseStep;
import net.xfra.qizxopen.xquery.op.RootStep;
import net.xfra.qizxopen.xquery.op.SchemaContext;
import net.xfra.qizxopen.xquery.op.SelfStep;
import net.xfra.qizxopen.xquery.op.SequenceExpr;
import net.xfra.qizxopen.xquery.op.StringLiteral;
import net.xfra.qizxopen.xquery.op.TreatExpr;
import net.xfra.qizxopen.xquery.op.TypeswitchExpr;
import net.xfra.qizxopen.xquery.op.UnionOp;
import net.xfra.qizxopen.xquery.op.ValidateExpr;
import net.xfra.qizxopen.xquery.op.ValueEqOp;
import net.xfra.qizxopen.xquery.op.ValueGeOp;
import net.xfra.qizxopen.xquery.op.ValueGtOp;
import net.xfra.qizxopen.xquery.op.ValueLeOp;
import net.xfra.qizxopen.xquery.op.ValueLtOp;
import net.xfra.qizxopen.xquery.op.ValueNeOp;
import net.xfra.qizxopen.xquery.op.VarReference;

public class Parser
extends Lexer {
    int curToken = -1;
    int prevTokenLoc;
    Module predefinedModule = PredefinedModule.BASE;
    NSPrefixMapping predefinedNS;
    HashMap collations;
    ModuleManager moduleManager;
    Pragma[] pragmas = new Pragma[0];
    boolean preserveSpace = false;
    public static final String XQUERY_VERSION = "1.0";

    public Parser(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public Query parseQuery(CharSequence charSequence, String string, Log log) throws XQueryException {
        this.log = log;
        this.startLexer(charSequence);
        this.nextToken();
        Query query = new Query();
        this.currentModule = query;
        this.setupModule(charSequence, string);
        this.parseOptVersion();
        this.parseProlog();
        query.body = this.parseExpr();
        if (this.curToken != 149 && this.curToken != 0) {
            this.syntax("unrecognized characters at end of query");
        }
        if (this.stateSP != 0) {
            System.err.println("*** " + this.stateSP + " unpopped lexical states");
        }
        this.currentModule.storePragmas(this.pragmas);
        return query;
    }

    public Module parseLibraryModule(Module module, CharSequence charSequence, String string, Log log) throws XQueryException {
        this.log = log;
        this.startLexer(charSequence);
        this.nextToken();
        this.currentModule = module;
        this.setupModule(charSequence, string);
        this.parseOptVersion();
        this.wantToken(183);
        if (this.curToken != 113) {
            this.syntax("expecting prefix");
        }
        String string2 = this.makeString();
        this.wantToken(4);
        if (this.curToken != 168) {
            this.checkToken(158);
        }
        String string3 = this.makeString();
        this.currentModule.setDeclaredURI(string3);
        this.currentModule.addNamespaceDecl(string2, string3);
        this.pickToken(149);
        this.parseProlog();
        if (this.curToken != 0) {
            this.syntax("unrecognized characters at end of query");
        }
        this.currentModule.storePragmas(this.pragmas);
        return this.currentModule;
    }

    public void setPredefinedModule(Module module) {
        this.predefinedModule = module;
    }

    public void setPredefinedNamespaces(NSPrefixMapping nSPrefixMapping) {
        this.predefinedNS = nSPrefixMapping;
    }

    public void setCollations(HashMap hashMap) {
        this.collations = hashMap;
    }

    private void setupModule(CharSequence charSequence, String string) {
        this.currentModule.setPredefinedModule(this.predefinedModule);
        this.currentModule.setLog(this.log);
        this.currentModule.setSource(charSequence, string);
        this.currentModule.setCollations(this.collations);
        if (this.predefinedNS != null) {
            int n = this.predefinedNS.getMappingCount();
            while (n >= 1) {
                this.currentModule.addNamespaceDecl(this.predefinedNS.getLastPrefix(n), this.predefinedNS.getLastNamespace(n).getURI());
                --n;
            }
        }
    }

    private void parseOptVersion() throws XQueryException {
        if (this.curToken != 188) {
            return;
        }
        String string = this.makeString();
        if (string.compareTo(XQUERY_VERSION) > 0) {
            this.log.error(this.currentModule, this.prevTokenLoc, "XML Query version %1 not supported, the current version is %2", string, XQUERY_VERSION);
        }
        this.wantToken(149);
    }

    void parseProlog() throws XQueryException {
        block17: while (true) {
            int n = this.tokenStart;
            switch (this.curToken) {
                case 42: {
                    this.nextToken();
                    this.parseNamespaceDecl();
                    break;
                }
                case 47: 
                case 48: {
                    this.parseDefaultNamespaceDecl();
                    break;
                }
                case 44: {
                    this.nextToken();
                    this.wantToken(179);
                    if (this.pickToken(180)) {
                        this.preserveSpace = true;
                        break;
                    }
                    if (this.pickToken(181)) {
                        this.preserveSpace = false;
                        break;
                    }
                    this.syntax("expecting preserve or strip");
                    break;
                }
                case 46: {
                    this.nextToken();
                    this.checkToken(168);
                    this.currentModule.setDefaultCollation(this.makeString());
                    break;
                }
                case 190: {
                    this.nextToken();
                    this.checkToken(174);
                    n = this.tokenStart;
                    Type type = null;
                    QName qName = this.resolveVarName();
                    if (qName.getNamespace() != this.currentModule.getNamespace() && (qName.getNamespace() != Namespace.NONE || this.currentModule.getNamespace() != Module.LOCAL_NS)) {
                        this.log.error(this.currentModule, this.prevTokenLoc, "namespace of variable name %1 should match", this.currentModule.prefixedName(qName));
                    }
                    if (this.pickToken(2)) {
                        type = this.parseSequenceType();
                    }
                    Expression expression = null;
                    if (!this.pickToken(191)) {
                        expression = this.parseEnclosedExpr();
                    }
                    GlobalVariable globalVariable = new GlobalVariable(qName, type, expression);
                    this.currentModule.addDeclaration(this.locate(globalVariable, n));
                    break;
                }
                case 49: {
                    this.parseFunctionDefn();
                    break;
                }
                case 189: {
                    this.nextToken();
                    String string = null;
                    String string2 = null;
                    if (this.pickToken(116)) {
                        this.checkToken(113);
                        string = this.makeString();
                        this.wantToken(4);
                    }
                    if (this.curToken != 158) {
                        this.checkToken(168);
                    }
                    String string3 = this.makeString();
                    if (this.curToken == 6) {
                        string2 = this.makeString();
                    }
                    this.moduleImport(n, string3, string2);
                    if (string == null) break;
                    this.currentModule.addNamespaceDecl(string, string3);
                    break;
                }
                case 90: {
                    this.nextToken();
                    switch (this.curToken) {
                        case 47: 
                        case 48: {
                            this.parseDefaultNamespaceDecl();
                            break;
                        }
                        case 116: {
                            this.nextToken();
                            this.parseNamespaceDecl();
                            break;
                        }
                        case 158: {
                            this.nextToken();
                            break;
                        }
                        default: {
                            this.syntax("improper schema import");
                        }
                    }
                    if (this.pickToken(6)) {
                        this.makeString();
                    }
                    this.log.error(this.currentModule, n, "schema import is not supported");
                    break;
                }
                case 192: 
                case 193: 
                case 194: {
                    this.log.warning(this.currentModule, n, "validation directive ignored", "");
                    this.nextToken();
                    break;
                }
                case 200: {
                    this.parseTemplate();
                    break;
                }
                default: {
                    break block17;
                }
            }
            this.pickToken(149);
        }
    }

    void parseNamespaceDecl() throws XQueryException {
        if (this.curToken != 113) {
            this.syntax("expecting prefix");
        }
        String string = this.makeString();
        this.wantToken(4);
        if (this.curToken != 168) {
            this.wantToken(168);
        }
        this.currentModule.addNamespaceDecl(string, this.makeString());
    }

    void parseDefaultNamespaceDecl() throws XQueryException {
        boolean bl = this.curToken == 48;
        this.nextToken();
        this.wantToken(116);
        this.wantToken(4);
        if (this.curToken != 168 && this.curToken != 158) {
            this.wantToken(168);
        }
        this.currentModule.addDefaultNamespace(bl, this.makeString());
    }

    Expression parseExpr() throws XQueryException {
        Expression expression = this.parseExprSingle();
        if (this.curToken != 38) {
            return expression;
        }
        SequenceExpr sequenceExpr = new SequenceExpr();
        this.locate(sequenceExpr);
        sequenceExpr.addExpr(expression);
        while (this.pickToken(38)) {
            sequenceExpr.addExpr(this.parseExprSingle());
        }
        return sequenceExpr;
    }

    Expression parseExprSingle() throws XQueryException {
        switch (this.curToken) {
            case 76: 
            case 103: {
                return this.parseFLWRExpr();
            }
            case 72: 
            case 152: {
                return this.parseQuantifiedExpr();
            }
            case 167: {
                return this.parseTypeswitchExpr();
            }
            case 89: {
                return this.parseIfExpr();
            }
        }
        return this.parseOrExpr();
    }

    Expression parseFLWRExpr() throws XQueryException {
        if (this.curToken != 76 && this.curToken != 103) {
            return this.parseQuantifiedExpr();
        }
        FLWRExpr fLWRExpr = new FLWRExpr();
        this.locate(fLWRExpr);
        while (this.curToken == 76 || this.curToken == 103) {
            if (this.pickToken(76)) {
                fLWRExpr.addClause(this.parseForClause(true));
                while (this.pickToken(38)) {
                    this.wantToken(175);
                    fLWRExpr.addClause(this.parseForClause(true));
                }
                continue;
            }
            if (!this.pickToken(103)) continue;
            fLWRExpr.addClause(this.parseLetClause());
            while (this.pickToken(38)) {
                this.wantToken(175);
                fLWRExpr.addClause(this.parseLetClause());
            }
        }
        if (this.pickToken(177)) {
            fLWRExpr.where = this.parseExpr();
        }
        if (this.pickToken(126)) {
            fLWRExpr.addOrderSpec(this.parseOrderSpec());
            while (this.pickToken(38)) {
                fLWRExpr.addOrderSpec(this.parseOrderSpec());
            }
        } else if (this.pickToken(127)) {
            fLWRExpr.stableOrder = true;
            fLWRExpr.addOrderSpec(this.parseOrderSpec());
            while (this.pickToken(38)) {
                fLWRExpr.addOrderSpec(this.parseOrderSpec());
            }
        }
        this.wantToken(142);
        fLWRExpr.expr = this.parseFLWRExpr();
        return fLWRExpr;
    }

    LetClause parseLetClause() throws XQueryException {
        int n = this.prevTokenLoc;
        this.checkToken(174);
        LetClause letClause = new LetClause(this.resolveVarName());
        this.locate(letClause, n);
        if (this.pickToken(2)) {
            letClause.varType = this.parseSequenceType();
        }
        this.wantToken(36);
        letClause.expr = this.parseExprSingle();
        return letClause;
    }

    ForClause parseForClause(boolean bl) throws XQueryException {
        int n = this.prevTokenLoc;
        this.checkToken(174);
        ForClause forClause = new ForClause(this.resolveVarName());
        this.locate(forClause, n);
        if (this.pickToken(2)) {
            forClause.varType = this.parseSequenceType();
        }
        if (bl && this.pickToken(7)) {
            this.wantToken(175);
            forClause.position = this.resolveVarName();
        }
        this.wantToken(91);
        forClause.expr = this.parseExprSingle();
        return forClause;
    }

    OrderSpec parseOrderSpec() throws XQueryException {
        int n = this.tokenStart;
        OrderSpec orderSpec = new OrderSpec(this.parseExprSingle());
        this.locate(orderSpec, n);
        if (this.pickToken(50)) {
            orderSpec.descending = true;
        } else {
            this.pickToken(3);
        }
        if (this.pickToken(64)) {
            orderSpec.emptyGreatest = true;
        } else {
            this.pickToken(65);
        }
        if (this.pickToken(35)) {
            orderSpec.collation = this.makeString();
        }
        return orderSpec;
    }

    Expression parseQuantifiedExpr() throws XQueryException {
        if (this.curToken != 152 && this.curToken != 72) {
            return this.parseTypeswitchExpr();
        }
        QuantifiedExpr quantifiedExpr = new QuantifiedExpr(this.curToken == 72);
        this.locate(quantifiedExpr);
        this.nextToken();
        quantifiedExpr.addVarClause(this.parseForClause(false));
        while (this.pickToken(38)) {
            this.wantToken(175);
            quantifiedExpr.addVarClause(this.parseForClause(false));
        }
        this.wantToken(148);
        quantifiedExpr.cond = this.parseExprSingle();
        return quantifiedExpr;
    }

    Expression parseTypeswitchExpr() throws XQueryException {
        CaseClause caseClause;
        int n = this.tokenStart;
        if (!this.pickToken(167)) {
            return this.parseIfExpr();
        }
        TypeswitchExpr typeswitchExpr = new TypeswitchExpr(this.parseExpr());
        this.locate(typeswitchExpr, n);
        this.wantToken(145);
        while (this.pickToken(26)) {
            caseClause = new CaseClause();
            this.locate2(caseClause);
            typeswitchExpr.addCaseClause(caseClause);
            if (this.pickToken(175)) {
                this.checkToken(174);
                caseClause.variable = this.resolveVarName();
                this.wantToken(2);
            }
            caseClause.varType = this.parseSequenceType();
            this.wantToken(142);
            caseClause.expr = this.parseExprSingle();
        }
        this.wantToken(45);
        caseClause = new CaseClause();
        this.locate2(caseClause);
        typeswitchExpr.addCaseClause(caseClause);
        if (this.pickToken(175)) {
            this.checkToken(174);
            caseClause.variable = this.resolveVarName();
            this.wantToken(2);
        }
        this.wantToken(142);
        caseClause.expr = this.parseExpr();
        return typeswitchExpr;
    }

    Expression parseIfExpr() throws XQueryException {
        int n = this.tokenStart;
        if (!this.pickToken(89)) {
            return this.parseInstanceofExpr();
        }
        Expression expression = this.parseExpr();
        this.wantToken(145);
        this.wantToken(163);
        Expression expression2 = this.parseExpr();
        this.wantToken(62);
        return this.locate(new IfExpr(expression, expression2, this.parseExprSingle()), n);
    }

    Expression parseOrExpr() throws XQueryException {
        Expression expression = this.parseAndExpr();
        if (this.curToken != 125) {
            return expression;
        }
        OrExpr orExpr = new OrExpr(expression);
        this.locate(orExpr);
        while (this.pickToken(125)) {
            orExpr.addExpr(this.parseAndExpr());
        }
        return orExpr;
    }

    Expression parseAndExpr() throws XQueryException {
        Expression expression = this.parseInstanceofExpr();
        if (this.curToken != 1) {
            return expression;
        }
        AndExpr andExpr = new AndExpr(expression);
        this.locate(andExpr);
        while (this.pickToken(1)) {
            andExpr.addExpr(this.parseInstanceofExpr());
        }
        return andExpr;
    }

    Expression parseInstanceofExpr() throws XQueryException {
        Expression expression = this.parseTreatExpr();
        int n = this.tokenStart;
        if (this.pickToken(93)) {
            expression = new InstanceofExpr(expression, this.parseSequenceType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseTreatExpr() throws XQueryException {
        Expression expression = this.parseCastableExpr();
        int n = this.tokenStart;
        if (this.pickToken(165)) {
            expression = new TreatExpr(expression, this.parseSequenceType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseCastableExpr() throws XQueryException {
        Expression expression = this.parseCastExpr();
        int n = this.tokenStart;
        if (this.pickToken(28)) {
            expression = new CastableExpr(expression, this.parseSingleType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseCastExpr() throws XQueryException {
        Expression expression = this.parseComparisonExpr();
        int n = this.tokenStart;
        if (this.pickToken(27)) {
            expression = new CastExpr(expression, this.parseSingleType());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseComparisonExpr() throws XQueryException {
        Expression expression = this.parseRangeExpr();
        block18: while (true) {
            int n = this.tokenStart;
            switch (this.curToken) {
                case 81: {
                    this.nextToken();
                    expression = new ValueLtOp(expression, this.parseRangeExpr());
                    break;
                }
                case 77: {
                    this.nextToken();
                    expression = new ValueEqOp(expression, this.parseRangeExpr());
                    break;
                }
                case 80: {
                    this.nextToken();
                    expression = new ValueLeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 82: {
                    this.nextToken();
                    expression = new ValueNeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 79: {
                    this.nextToken();
                    expression = new ValueGtOp(expression, this.parseRangeExpr());
                    break;
                }
                case 78: {
                    this.nextToken();
                    expression = new ValueGeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 83: {
                    this.nextToken();
                    expression = new GtOp(expression, this.parseRangeExpr());
                    break;
                }
                case 84: {
                    this.nextToken();
                    expression = new GeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 107: {
                    this.nextToken();
                    expression = new LtOp(expression, this.parseRangeExpr());
                    break;
                }
                case 108: {
                    this.nextToken();
                    expression = new LeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 69: {
                    this.nextToken();
                    expression = new EqOp(expression, this.parseRangeExpr());
                    break;
                }
                case 121: {
                    this.nextToken();
                    expression = new NeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 97: {
                    this.nextToken();
                    expression = new IsNotOp(expression, this.parseRangeExpr());
                    break;
                }
                case 96: {
                    this.nextToken();
                    expression = new IsOp(expression, this.parseRangeExpr());
                    break;
                }
                case 109: {
                    this.nextToken();
                    expression = new BeforeOp(expression, this.parseRangeExpr());
                    break;
                }
                case 85: {
                    this.nextToken();
                    expression = new AfterOp(expression, this.parseRangeExpr());
                    break;
                }
                default: {
                    break block18;
                }
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseRangeExpr() throws XQueryException {
        Expression expression = this.parseAdditiveExpr();
        int n = this.tokenStart;
        if (this.pickToken(164)) {
            expression = new RangeExpr(expression, this.parseAdditiveExpr());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseAdditiveExpr() throws XQueryException {
        Expression expression = this.parseMultiplicativeExpr();
        while (true) {
            int n = this.tokenStart;
            if (this.pickToken(129)) {
                expression = new PlusOp(expression, this.parseMultiplicativeExpr());
            } else {
                if (!this.pickToken(110)) break;
                expression = new MinusOp(expression, this.parseMultiplicativeExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseMultiplicativeExpr() throws XQueryException {
        Expression expression = this.parseUnaryExpr();
        while (true) {
            int n = this.tokenStart;
            if (this.pickToken(112)) {
                expression = new MulOp(expression, this.parseUnaryExpr());
            } else if (this.pickToken(53)) {
                expression = new DivOp(expression, this.parseUnaryExpr());
            } else if (this.pickToken(88)) {
                expression = new IDivOp(expression, this.parseUnaryExpr());
            } else {
                if (!this.pickToken(111)) break;
                expression = new ModOp(expression, this.parseUnaryExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws XQueryException {
        if (this.pickToken(110)) {
            int n = this.prevTokenLoc;
            return this.locate(new NegateOp(this.parseUnaryExpr()), n);
        }
        if (this.pickToken(129)) {
            return this.parseUnaryExpr();
        }
        return this.parseUnionExpr();
    }

    Expression parseUnionExpr() throws XQueryException {
        Expression expression = this.parseIntersectExceptExpr();
        while (this.pickToken(169) || this.pickToken(176)) {
            int n = this.prevTokenLoc;
            expression = new UnionOp(expression, this.parseIntersectExceptExpr());
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws XQueryException {
        Expression expression = this.parseValueExpr();
        while (true) {
            int n = this.tokenStart;
            if (this.pickToken(95)) {
                expression = new IntersectOp(expression, this.parseMultiplicativeExpr());
            } else {
                if (!this.pickToken(73)) break;
                expression = new ExceptOp(expression, this.parseMultiplicativeExpr());
            }
            this.locate(expression, n);
        }
        return expression;
    }

    Expression parseValueExpr() throws XQueryException {
        if (this.curToken == 172) {
            return this.parseValidateExpr();
        }
        return this.parsePathExpr();
    }

    Expression parsePathExpr() throws XQueryException {
        int n = this.tokenStart;
        boolean bl = false;
        boolean bl2 = false;
        if (this.pickToken(143)) {
            bl = true;
        } else if (this.pickToken(144)) {
            bl2 = true;
            bl = true;
        }
        Expression expression = this.parseStepExpr();
        PathExpr pathExpr = null;
        if (bl || expression instanceof ReverseStep) {
            pathExpr = new PathExpr();
            this.locate(pathExpr, n);
            if (bl) {
                pathExpr.addStep(this.locate(new RootStep(null), n));
            }
            if (bl2) {
                if (expression != null) {
                    pathExpr.addStep(this.locate(new DescendantOrSelfStep(null), n));
                } else {
                    this.syntax("unterminated path '//'");
                }
            }
            if (expression != null) {
                pathExpr.addStep(expression);
            }
        } else if (expression == null) {
            this.syntax("expecting expression");
        }
        if (this.curToken != 150 && this.curToken != 151) {
            return pathExpr != null ? pathExpr : expression;
        }
        if (pathExpr == null) {
            pathExpr = new PathExpr();
            this.locate(pathExpr, n);
            pathExpr.addStep(expression);
        }
        while (this.curToken == 150 || this.curToken == 151) {
            if (this.pickToken(151)) {
                pathExpr.addStep(this.locate(new DescendantOrSelfStep(null), n));
            } else {
                this.nextToken();
            }
            expression = this.parseStepExpr();
            if (expression == null) {
                this.syntax("unterminated path expression");
            }
            pathExpr.addStep(expression);
        }
        this.locate(pathExpr, n);
        return pathExpr;
    }

    Expression parseStepExpr() throws XQueryException {
        Expression expression = null;
        int n = this.tokenStart;
        switch (this.curToken) {
            case 57: {
                this.nextToken();
                expression = new AncestorStep(null);
                break;
            }
            case 12: {
                this.nextToken();
                expression = new AncestorStep(this.parseNodeTest());
                break;
            }
            case 13: {
                this.nextToken();
                expression = new AncestorOrSelfStep(this.parseNodeTest());
                break;
            }
            case 14: {
                this.nextToken();
                expression = new AttributeStep(this.parseNodeTest());
                break;
            }
            case 5: {
                this.nextToken();
                expression = new AttributeStep(this.parseNameTest(true));
                break;
            }
            case 15: {
                this.nextToken();
                expression = new ChildStep(this.parseNodeTest());
                break;
            }
            case 16: {
                this.nextToken();
                expression = new DescendantStep(this.parseNodeTest());
                break;
            }
            case 17: {
                this.nextToken();
                expression = new DescendantOrSelfStep(this.parseNodeTest());
                break;
            }
            case 18: {
                this.nextToken();
                expression = new FollowingStep(this.parseNodeTest());
                break;
            }
            case 19: {
                this.nextToken();
                expression = new FollowingSiblingStep(this.parseNodeTest());
                break;
            }
            case 24: {
                this.nextToken();
                expression = new SelfStep(this.parseNodeTest());
                break;
            }
            case 21: {
                this.nextToken();
                expression = new ParentStep(this.parseNodeTest());
                break;
            }
            case 23: {
                this.nextToken();
                expression = new PrecedingSiblingStep(this.parseNodeTest());
                break;
            }
            case 22: {
                this.nextToken();
                expression = new PrecedingStep(this.parseNodeTest());
                break;
            }
            case 56: {
                this.nextToken();
                expression = new SelfStep(null);
                break;
            }
            case 186: {
                expression = new AttributeStep(this.parseNodeTest(true));
                break;
            }
            case 40: 
            case 114: 
            case 120: 
            case 133: 
            case 137: 
            case 153: 
            case 154: 
            case 162: 
            case 184: 
            case 185: {
                expression = new ChildStep(this.parseNodeTest());
                break;
            }
            case 102: {
                this.syntax("unexpected '['");
            }
            default: {
                expression = this.parsePrimaryExpr();
            }
        }
        if (expression != null) {
            this.locate(expression, n);
        }
        FilterExpr filterExpr = expression instanceof FilterExpr ? (FilterExpr)expression : null;
        while (this.pickToken(102)) {
            n = this.prevTokenLoc;
            if (filterExpr == null) {
                filterExpr = new FilterExpr(expression);
            }
            filterExpr.addPredicate(this.parseExpr());
            this.locate(expression, n);
            this.wantToken(141);
        }
        return filterExpr == null ? expression : filterExpr;
    }

    Expression parseValidateExpr() throws XQueryException {
        int n = this.tokenStart;
        this.wantToken(172);
        int n2 = -1;
        if (this.pickKeyword("lax")) {
            n2 = 1;
        } else if (this.pickKeyword("strict")) {
            n2 = 2;
        } else if (this.pickKeyword("skip")) {
            n2 = 3;
        }
        SchemaContext schemaContext = null;
        if (!this.pickToken(101)) {
            schemaContext = this.parseSchemaContext();
            this.wantToken(101);
        }
        Expression expression = this.parseExpr();
        this.wantToken(140);
        expression = new ValidateExpr(n2, schemaContext, expression);
        this.locate(expression, n);
        return expression;
    }

    Expression parsePrimaryExpr() throws XQueryException {
        switch (this.curToken) {
            case 41: {
                return this.locate2(new DecimalLiteral(this.makeDecimal()));
            }
            case 58: {
                return this.locate2(new DoubleLiteral(this.makeNumber()));
            }
            case 94: {
                return this.locate2(new IntegerLiteral(this.makeInteger()));
            }
            case 158: {
                return this.locate2(this.makeStringLiteral());
            }
            case 138: {
                return this.parseFunctionCall();
            }
            case 175: {
                this.nextToken();
                this.checkToken(174);
                return this.locate2(new VarReference(this.resolveVarName()));
            }
            case 106: {
                return this.parseParenthesizedExpr();
            }
            case 9: 
            case 10: 
            case 30: 
            case 55: 
            case 59: 
            case 60: 
            case 132: 
            case 156: 
            case 157: 
            case 161: 
            case 182: 
            case 195: 
            case 196: 
            case 197: 
            case 198: {
                return this.parseConstructor();
            }
        }
        return null;
    }

    Expression parseParenthesizedExpr() throws XQueryException {
        this.wantToken(106);
        if (this.pickToken(145)) {
            return new SequenceExpr();
        }
        Expression expression = this.parseExpr();
        this.wantToken(145);
        return expression;
    }

    Expression parseFunctionCall() throws XQueryException {
        int n = this.tokenStart;
        this.checkToken(138);
        QName qName = this.resolveQName(this.currentModule.getDefaultFunctionNS());
        FunctionCall functionCall = new FunctionCall(qName);
        this.locate(functionCall, n);
        if (!this.pickToken(145)) {
            functionCall.addArgument(this.parseExprSingle());
            while (this.pickToken(38)) {
                functionCall.addArgument(this.parseExprSingle());
            }
            this.wantToken(145);
        }
        return functionCall;
    }

    ItemType checkTypeName(QName qName) {
        ItemType itemType = this.currentModule.lookForType(qName);
        if (itemType == null) {
            this.log.error(this.currentModule, this.prevTokenLoc, "unknown type %1", this.currentModule.prefixedName(qName));
            return Type.ITEM;
        }
        if (!Type.ATOM.accepts(itemType)) {
            this.log.error(this.currentModule, this.prevTokenLoc, "non atomic type %1", this.currentModule.prefixedName(qName));
        }
        return itemType;
    }

    Type parseSingleType() throws XQueryException {
        this.checkToken(137);
        ItemType itemType = this.checkTypeName(this.resolveElementName());
        return this.pickToken(136) ? itemType.opt : itemType;
    }

    Type parseSequenceType() throws XQueryException {
        if (this.pickToken(63)) {
            return Type.NONE;
        }
        ItemType itemType = this.parseItemType();
        if (this.pickToken(153) || this.pickToken(112)) {
            return itemType.star;
        }
        if (this.pickToken(129)) {
            return new SequenceType(itemType, 2);
        }
        if (this.pickToken(136)) {
            return new SequenceType(itemType, 1);
        }
        return itemType;
    }

    ItemType parseItemType() throws XQueryException {
        switch (this.curToken) {
            case 40: 
            case 120: 
            case 133: 
            case 162: 
            case 184: 
            case 185: {
                return new NodeType(this.parseNodeTest());
            }
            case 186: {
                return new NodeType(this.parseNodeTest(true));
            }
            case 137: {
                ItemType itemType = this.checkTypeName(this.resolveElementName());
                return itemType;
            }
            case 187: {
                this.nextToken();
                return Type.ITEM;
            }
        }
        this.syntax("expecting item type");
        return null;
    }

    NodeTest parseNodeTest() throws XQueryException {
        return this.parseNodeTest(false);
    }

    NodeTest parseNodeTest(boolean bl) throws XQueryException {
        int n = this.tokenStart;
        switch (this.curToken) {
            case 184: {
                this.nextToken();
                NodeTest nodeTest = this.curToken == 145 ? null : this.parseElemAttrTest(false);
                this.wantToken(145);
                if (nodeTest == null) {
                    nodeTest = new BaseNodeTest(2, null, null);
                }
                return this.locate(n, new DocumentTest(nodeTest));
            }
            case 185: {
                return this.locate(n, this.parseElemAttrTest(false));
            }
            case 186: {
                return this.locate(n, this.parseElemAttrTest(true));
            }
            case 162: {
                this.nextToken();
                this.wantToken(145);
                return this.locate(n, new BaseNodeTest(4, null, null));
            }
            case 133: {
                this.nextToken();
                String string = null;
                if (this.curToken == 158) {
                    string = this.makeString();
                } else if (this.curToken == 137) {
                    string = this.makeString();
                }
                this.wantToken(145);
                return this.locate(n, new BaseNodeTest(5, null, string));
            }
            case 40: {
                this.nextToken();
                this.wantToken(145);
                return this.locate(n, new BaseNodeTest(6, null, null));
            }
            case 120: {
                this.nextToken();
                this.wantToken(145);
                return null;
            }
        }
        return this.parseNameTest(bl);
    }

    NodeTest parseElemAttrTest(boolean bl) throws XQueryException {
        QName qName;
        this.wantToken(bl ? 186 : 185);
        Namespace namespace = null;
        String string = null;
        SchemaContext schemaContext = null;
        if (this.curToken != 145 && !this.pickToken(153) && (schemaContext = this.parseSchemaContextPath()).isSimpleName()) {
            qName = schemaContext.getStep(0);
            schemaContext = null;
            namespace = qName.getNamespace();
            string = qName.getLocalName();
        }
        if (schemaContext == null && this.pickToken(38)) {
            qName = this.parseStarName();
            schemaContext = new SchemaContext(true);
            this.locate2(schemaContext);
            schemaContext.addStep(qName);
        }
        this.wantToken(145);
        if (schemaContext != null) {
            this.log.error(schemaContext.module, schemaContext.location, "Schema Type test not supported");
        }
        return new BaseNodeTest(bl ? 3 : 2, namespace, string);
    }

    QName parseStarName() throws XQueryException {
        if (this.curToken == 137) {
            return this.resolveElementName();
        }
        if (!this.pickToken(153)) {
            this.syntax("expecting name or '*'");
        }
        return null;
    }

    NodeTest parseNameTest(boolean bl) throws XQueryException {
        int n = this.tokenStart;
        Namespace namespace = bl ? Namespace.NONE : this.currentModule.getDefaultElementNS();
        int n2 = bl ? 3 : 2;
        switch (this.curToken) {
            case 137: {
                return this.locate(n, new BaseNodeTest(n2, this.expandPrefix(this.prefixValue, namespace), this.makeString()));
            }
            case 154: {
                return this.locate(n, new BaseNodeTest(n2, null, this.makeString()));
            }
            case 153: {
                this.nextToken();
                return this.locate(n, new BaseNodeTest(n2, null, null));
            }
            case 114: {
                return this.locate(n, new BaseNodeTest(n2, this.expandPrefix(this.makeString(), namespace), null));
            }
        }
        this.syntax("expecting name test");
        return null;
    }

    SchemaContext parseSchemaContext() throws XQueryException {
        if (this.pickKeyword("global")) {
            return null;
        }
        if (this.pickKeyword("context")) {
            return this.parseSchemaContextPath();
        }
        this.syntax("expecting schema context");
        return null;
    }

    SchemaContext parseSchemaContextPath() throws XQueryException {
        SchemaContext schemaContext = new SchemaContext(this.curToken == 166);
        if (this.curToken != 166 && this.curToken != 137) {
            this.wantToken(137);
        }
        schemaContext.addStep(this.resolveElementName());
        while (this.pickToken(150)) {
            if (this.curToken == 137) {
                schemaContext.addStep(this.resolveElementName());
                continue;
            }
            schemaContext.endsWithSlash = true;
            break;
        }
        return schemaContext;
    }

    Expression parseConstructor() throws XQueryException {
        int n = this.tokenStart;
        Expression expression = null;
        switch (this.curToken) {
            case 156: 
            case 157: {
                return this.parseElementConstructor();
            }
            case 182: {
                return this.locate(new AtomConstructor(6, this.makeStringLiteral()), n);
            }
            case 132: {
                return this.locate(new PIConstructor(this.makeString()), n);
            }
            case 161: {
                this.nextToken();
                if (!this.pickToken(140)) {
                    expression = this.parseExpr();
                    this.wantToken(140);
                }
                return new AtomConstructor(4, expression);
            }
            case 55: {
                this.nextToken();
                expression = new DocumentConstructor(this.parseExpr());
                this.wantToken(140);
                return expression;
            }
            case 9: 
            case 59: {
                NamedConstructor namedConstructor = this.curToken == 59 ? new ElementConstructor(null) : new AttributeConstructor(null);
                this.nextToken();
                namedConstructor.name = this.parseExpr();
                this.wantToken(140);
                this.wantToken(101);
                if (!this.pickToken(140)) {
                    namedConstructor.addItem(this.parseExpr());
                    this.wantToken(140);
                }
                return this.locate(namedConstructor, n);
            }
            case 10: 
            case 60: {
                NamedConstructor namedConstructor;
                int n2 = this.curToken;
                QNameLiteral qNameLiteral = new QNameLiteral(this.resolveElementName());
                NamedConstructor namedConstructor2 = namedConstructor = n2 == 60 ? new ElementConstructor(qNameLiteral) : new AttributeConstructor(qNameLiteral);
                if (!this.pickToken(140)) {
                    namedConstructor.addItem(this.parseExpr());
                    this.wantToken(140);
                }
                return this.locate(namedConstructor, n);
            }
            case 195: {
                this.nextToken();
                expression = this.parseExpr();
                this.wantToken(140);
                return this.locate(new AtomConstructor(6, expression), n);
            }
            case 196: {
                String string = this.makeString();
                expression = this.parseExpr();
                this.wantToken(140);
                return this.locate(new NamespaceConstructor(new StringLiteral(string), expression), n);
            }
            case 197: {
                this.nextToken();
                Expression expression2 = this.parseExpr();
                this.wantToken(140);
                this.wantToken(101);
                if (!this.pickToken(140)) {
                    expression = this.parseExpr();
                    this.wantToken(140);
                }
                return this.locate(new PIConstructor(expression2, expression), n);
            }
            case 198: {
                String string = this.makeString();
                expression = this.parseExpr();
                this.wantToken(140);
                return this.locate(new PIConstructor(new StringLiteral(string), expression), n);
            }
        }
        this.syntax("illegal constructor");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    ElementConstructor parseElementConstructor() throws XQueryException {
        Object object;
        Object object2;
        Object object3;
        int n = this.tokenStart;
        int n2 = 0;
        if (!this.pickToken(157)) {
            this.wantToken(156);
        }
        this.checkToken(159);
        String string = this.prefixValue;
        String string2 = this.makeString();
        ElementConstructor elementConstructor = new ElementConstructor(null);
        this.locate(elementConstructor, n);
        this.pickToken(147);
        while (this.curToken == 159) {
            object3 = new AttributeConstructor(null);
            ((AttributeConstructor)object3).prefix = this.prefixValue;
            ((AttributeConstructor)object3).value = this.makeString();
            this.locate2((Expression)object3);
            this.pickToken(147);
            this.wantToken(173);
            this.pickToken(147);
            this.parseAttributeValue((AttributeConstructor)object3);
            object2 = null;
            if (((AttributeConstructor)object3).prefix.equals("xmlns")) {
                object2 = ((AttributeConstructor)object3).value;
            } else if (((AttributeConstructor)object3).prefix.length() == 0 && ((AttributeConstructor)object3).value.equals("xmlns")) {
                object2 = "";
            }
            if (object2 == null) {
                elementConstructor.addAttribute((AttributeConstructor)object3);
                continue;
            }
            if (((AttributeConstructor)object3).contents.length != 1 || !(((AttributeConstructor)object3).contents[0] instanceof StringLiteral)) {
                this.log.error(((AttributeConstructor)object3).module, ((AttributeConstructor)object3).location, "namespace attribute must have a literal value");
                continue;
            }
            String string3 = ((StringLiteral)((AttributeConstructor)object3).contents[0]).value;
            this.currentModule.getInScopeNS().addMapping((String)object2, string3);
            ++n2;
            elementConstructor.addAttribute(new NamespaceConstructor((String)object2, string3));
        }
        object3 = this.expandPrefix(string);
        object2 = QName.get((Namespace)(object3 == null ? Namespace.NONE : object3), string2);
        elementConstructor.name = new QNameLiteral((QName)object2);
        this.locate(elementConstructor.name, n);
        int n3 = 0;
        int n4 = elementConstructor.attributes.size();
        while (n3 < n4) {
            object = elementConstructor.getAttribute(n3);
            if (!(object instanceof NamespaceConstructor)) {
                Namespace namespace = ((AttributeConstructor)object).prefix.length() == 0 ? Namespace.NONE : this.expandPrefix(((AttributeConstructor)object).prefix);
                ((AttributeConstructor)object).name = new QNameLiteral(QName.get(namespace, ((AttributeConstructor)object).value));
                ((AttributeConstructor)object).value = null;
                ((AttributeConstructor)object).prefix = null;
            }
            ++n3;
        }
        if (this.pickToken(66)) {
            this.currentModule.getInScopeNS().removeMappings(n2);
            return elementConstructor;
        }
        this.wantToken(155);
        object = new StringBuffer();
        block9: while (true) {
            ((StringBuffer)object).setLength(0);
            n = this.tokenStart;
            boolean bl = false;
            while (this.curToken == 31 || this.curToken == 32) {
                ((StringBuffer)object).append(this.saveBuffer);
                if (this.curToken == 32) {
                    bl = true;
                } else if (!bl && !this.preserveSpace) {
                    int n5 = this.saveBuffer.length();
                    while (--n5 >= 0) {
                        if (Character.isWhitespace(this.saveBuffer.charAt(n5))) continue;
                        bl = true;
                        break;
                    }
                }
                this.nextToken();
            }
            if (((StringBuffer)object).length() > 0 && (this.preserveSpace || bl)) {
                this.locate(elementConstructor.addTextItem(((StringBuffer)object).toString()), n);
            }
            switch (this.curToken) {
                case 100: 
                case 101: {
                    elementConstructor.addItem(this.parseEnclosedExpr());
                    break;
                }
                case 156: {
                    elementConstructor.addItem(this.parseElementConstructor());
                    break;
                }
                case 182: {
                    elementConstructor.addItem(this.locate2(new AtomConstructor(6, this.makeStringLiteral())));
                    break;
                }
                case 132: {
                    elementConstructor.addItem(this.locate2(new PIConstructor(this.makeString())));
                    break;
                }
                case 0: 
                case 68: {
                    break block9;
                }
            }
        }
        this.wantToken(68);
        this.checkToken(159);
        string = this.prefixValue;
        string2 = this.makeString();
        object3 = this.expandPrefix(string);
        QName qName = QName.get((Namespace)(object3 == null ? Namespace.NONE : object3), string2);
        if (qName != object2) {
            this.syntax("tag mismatch: " + qName + " encountered when expecting " + object2);
        }
        this.pickToken(147);
        this.wantToken(67);
        this.currentModule.getInScopeNS().removeMappings(n2);
        return elementConstructor;
    }

    void parseAttributeValue(AttributeConstructor attributeConstructor) throws XQueryException {
        int n;
        int n2 = n = this.curToken == 124 ? 34 : 33;
        if (!this.pickToken(124) && !this.pickToken(123)) {
            this.syntax("bad attribute delimiter");
        }
        while (true) {
            if (this.curToken == 31 || this.curToken == 32) {
                this.locate2(attributeConstructor.addTextItem(this.makeString()));
                continue;
            }
            if (this.curToken != 100 && this.curToken != 101) break;
            attributeConstructor.addItem(this.parseEnclosedExpr());
        }
        this.wantToken(n);
        if (attributeConstructor.contents.length == 0) {
            attributeConstructor.addTextItem("");
        }
    }

    Expression parseEnclosedExpr() throws XQueryException {
        if (!this.pickToken(101)) {
            this.wantToken(100);
        }
        Expression expression = this.parseExpr();
        this.wantToken(140);
        return expression;
    }

    UserFunction parseFunctionDefn() throws XQueryException {
        Object object;
        UserFunction userFunction;
        this.wantToken(49);
        this.checkToken(138);
        QName qName = this.resolveQName(null);
        if (qName.getNamespace() != this.currentModule.getNamespace()) {
            boolean bl = this.currentModule.getNamespace() == Module.LOCAL_NS;
            this.log.error(this.currentModule, this.prevTokenLoc, bl ? "function %1 should be declared in 'local' namespace" : "namespace of function name %1 does not match module namespace", this.currentModule.prefixedName(qName));
        }
        if ((userFunction = (UserFunction)this.currentModule.localFunctionLookup(qName)) == null) {
            userFunction = new UserFunction(this.currentModule, this.prevTokenLoc);
            this.currentModule.addDeclaration(userFunction);
        }
        UserFunction.Signature signature = userFunction.addPrototype(qName);
        this.currentModule.declareFunction(userFunction);
        if (this.curToken != 145 && this.curToken != 146) {
            this.wantToken(175);
            this.checkToken(174);
            object = this.resolveVarName();
            signature.arg((QName)object, this.pickToken(2) ? this.parseSequenceType() : Type.ANY);
            while (this.pickToken(38)) {
                this.wantToken(175);
                this.checkToken(174);
                object = this.resolveVarName();
                signature.arg((QName)object, this.pickToken(2) ? this.parseSequenceType() : Type.ANY);
            }
        }
        if (this.pickToken(146)) {
            signature.returnType = this.parseSequenceType();
        } else {
            this.wantToken(145);
        }
        object = null;
        if (!this.pickToken(191)) {
            object = this.parseEnclosedExpr();
        }
        signature.body = object;
        return userFunction;
    }

    void parseTemplate() throws XQueryException {
        int n = this.tokenStart;
        this.nextToken();
    }

    private void moduleImport(int n, String string, String string2) {
        try {
            Module module = this.moduleManager.loadModule(this.predefinedModule, string, string2, this.log);
            if (!string.equals(module.getDeclaredURI())) {
                this.log.error(this.currentModule, n, "module imported from '%1' declares a different URI (%2)", string, module.getDeclaredURI());
            }
            this.currentModule.addDeclaration(module);
        }
        catch (Exception exception) {
            this.log.error(this.currentModule, n, "module %1 cannot be imported: %2", string, exception.getMessage());
        }
    }

    private Expression makeStringLiteral() throws XQueryException {
        return this.locate2(new StringLiteral(this.makeString()));
    }

    private Namespace expandPrefix(String string) {
        Namespace namespace = this.currentModule.getInScopeNS().convertToNamespace(string);
        if (namespace == null && string.length() > 0) {
            this.log.error(this.currentModule, this.tokenStart, "unknown prefix '%1'", string);
            namespace = Namespace.NONE;
        }
        return namespace;
    }

    private Namespace expandPrefix(String string, Namespace namespace) {
        if (string == null || string.length() == 0) {
            return namespace;
        }
        return this.expandPrefix(string);
    }

    private QName resolveQName(Namespace namespace) throws XQueryException {
        if (namespace == null) {
            namespace = Namespace.NONE;
        }
        return QName.get(this.expandPrefix(this.prefixValue, namespace), this.makeString());
    }

    private QName resolveElementName() throws XQueryException {
        return this.resolveQName(this.currentModule.getDefaultElementNS());
    }

    private QName resolveVarName() throws XQueryException {
        return this.resolveQName(null);
    }

    void parsedExtension(int n, String string, String string2, String string3) {
        this.log.error(this.currentModule, n, "extension not supported: %1:%2 %3", new String[]{string, string2, string3});
    }

    void parsedPragma(int n, String string, String string2, String string3) {
        Pragma[] pragmaArray = this.pragmas;
        this.pragmas = new Pragma[pragmaArray.length + 1];
        System.arraycopy(pragmaArray, 0, this.pragmas, 0, pragmaArray.length);
        this.pragmas[pragmaArray.length] = new Pragma(QName.get(string + ':' + string2), string3);
    }

    private String makeString(int n) throws XQueryException {
        if (this.curToken != n) {
            this.wantToken(n);
        }
        return this.makeString();
    }

    private String makeString() throws XQueryException {
        String string = this.saveBuffer.toString();
        this.nextToken();
        return string;
    }

    private BigDecimal makeDecimal() throws XQueryException {
        BigDecimal bigDecimal;
        try {
            bigDecimal = Conversion.toDecimal(this.saveBuffer.toString());
        }
        catch (TypeException typeException) {
            this.log.error(this.currentModule, this.tokenStart, "invalid value of decimal literal '%1'", this.saveBuffer.toString());
            bigDecimal = new BigDecimal(0.0);
        }
        this.nextToken();
        return bigDecimal;
    }

    private double makeNumber() throws XQueryException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.saveBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            this.log.error(this.currentModule, this.tokenStart, "invalid value of double literal '%1'", this.saveBuffer.toString());
        }
        this.nextToken();
        return d;
    }

    private long makeInteger() throws XQueryException {
        long l = 0L;
        try {
            l = Conversion.toInteger(this.saveBuffer.toString());
        }
        catch (TypeException typeException) {
            this.log.error(this.currentModule, this.tokenStart, "value of integer literal '%1' out of bounds", this.saveBuffer.toString());
        }
        this.nextToken();
        return l;
    }

    boolean pickKeyword(String string) throws XQueryException {
        if (this.curToken != 137 || this.prefixValue.length() > 0 || !string.equals(this.saveBuffer.toString())) {
            return false;
        }
        this.nextToken();
        return true;
    }

    boolean pickToken(int n) throws XQueryException {
        if (this.curToken != n) {
            return false;
        }
        this.nextToken();
        return true;
    }

    void wantToken(int n) throws XQueryException {
        this.checkToken(n);
        this.nextToken();
    }

    void checkToken(int n) throws XQueryException {
        if (this.curToken != n) {
            this.syntax("expecting " + this.tokenName(n));
        }
    }

    void nextToken() throws XQueryException {
        this.prevTokenLoc = this.tokenStart;
        this.curToken = this.getToken();
    }

    Expression locate(Expression expression, int n) {
        expression.location = n;
        expression.module = this.currentModule;
        return expression;
    }

    Expression locate(Expression expression) {
        return this.locate(expression, this.tokenStart);
    }

    Expression locate2(Expression expression) {
        return this.locate(expression, this.prevTokenLoc);
    }

    NodeTest locate(int n, NodeTest nodeTest) {
        return nodeTest;
    }

    String tokenName(int n) {
        String string = Lexer.tokenNames[n];
        return string.length() > 1 && string.charAt(0) == '<' ? string : '\'' + string + '\'';
    }

    void syntax(String string) throws XQueryException {
        this.log.error(this.currentModule, this.tokenStart, "syntax error, near %1 : %2", this.tokenName(this.curToken), string);
        throw new SyntaxException(string, this.tokenStart);
    }
}

