/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Matches;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

public class Tokenize
extends Matches {
    static Prototype[] protos = new Prototype[]{Prototype.fn("tokenize", Type.STRING.star, class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec = Tokenize.class$("net.xfra.qizxopen.xquery.fn.Tokenize$Exec")) : class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec).arg("input", (Type)Type.STRING.opt).arg("pattern", (Type)Type.STRING), Prototype.fn("tokenize", Type.STRING.star, class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec = Tokenize.class$("net.xfra.qizxopen.xquery.fn.Tokenize$Exec")) : class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec).arg("input", (Type)Type.STRING.opt).arg("pattern", (Type)Type.STRING).arg("flags", (Type)Type.STRING)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$Tokenize$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Sequence
    extends StringValue {
        String source;
        String current;
        Pattern regexp;
        Matcher matcher;
        int lastStop = 0;

        Sequence(String string, Pattern pattern) {
            this.source = string;
            this.regexp = pattern;
            this.matcher = pattern.matcher(string);
        }

        public boolean next() throws XQueryException {
            if (this.lastStop < 0) {
                return false;
            }
            if (!this.matcher.find()) {
                this.current = this.source.substring(this.lastStop);
                this.lastStop = -1;
            } else {
                this.current = this.source.substring(this.lastStop, this.matcher.start());
                this.lastStop = this.matcher.end();
            }
            return true;
        }

        public String asString() throws TypeException {
            return this.current;
        }

        public Value bornAgain() {
            return new Sequence(this.source, this.regexp);
        }
    }

    public static class Exec
    extends Function.Call {
        Pattern precompiled;

        public void compilationHook() {
            Expression expression = this.args.length < 3 ? null : this.args[2];
            this.precompiled = Matches.precompileRegexp(this.args[1], expression, false);
        }

        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null) {
                return Value.empty;
            }
            evalContext.at(this);
            Expression expression = this.args.length < 3 ? null : this.args[2];
            Pattern pattern = this.precompiled != null ? this.precompiled : Matches.compileRegexp(this.args[1], expression, false, focus, evalContext);
            return new Sequence(string, pattern);
        }
    }
}

