/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.StringLiteral;

public class Matches
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("matches", Type.BOOLEAN.opt, class$net$xfra$qizxopen$xquery$fn$Matches$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$Matches$Exec = Matches.class$("net.xfra.qizxopen.xquery.fn.Matches$Exec")) : class$net$xfra$qizxopen$xquery$fn$Matches$Exec).arg("input", (Type)Type.STRING.opt).arg("pattern", (Type)Type.STRING), Prototype.fn("matches", Type.BOOLEAN.opt, class$net$xfra$qizxopen$xquery$fn$Matches$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$Matches$Exec = Matches.class$("net.xfra.qizxopen.xquery.fn.Matches$Exec")) : class$net$xfra$qizxopen$xquery$fn$Matches$Exec).arg("input", (Type)Type.STRING.opt).arg("pattern", (Type)Type.STRING).arg("flags", (Type)Type.STRING)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$Matches$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    public static int convertFlags(String string) {
        int n = 1;
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) == 'm') {
                n |= 8;
                continue;
            }
            if (string.charAt(n2) == 'i') {
                n |= 0x42;
                continue;
            }
            if (string.charAt(n2) == 's') {
                n |= 0x20;
                continue;
            }
            if (string.charAt(n2) == 'x') {
                n |= 4;
                continue;
            }
            return -1;
        }
        return n;
    }

    public static Pattern precompileRegexp(Expression expression, Expression expression2, boolean bl) {
        if (expression instanceof StringLiteral && (expression2 == null || expression2 instanceof StringLiteral)) {
            try {
                int n;
                String string = ((StringLiteral)expression).value;
                String string2 = "";
                if (expression2 != null) {
                    string2 = ((StringLiteral)expression2).value;
                }
                if ((n = Matches.convertFlags(string2)) < 0) {
                    return null;
                }
                Pattern pattern = Pattern.compile(string, n);
                if (!bl && pattern.matcher("").matches()) {
                    return null;
                }
                return pattern;
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
        }
        return null;
    }

    public static Pattern compileRegexp(Expression expression, Expression expression2, boolean bl, Focus focus, EvalContext evalContext) throws XQueryException {
        String string = expression.evalAsString(focus, evalContext);
        String string2 = expression2 == null ? "" : expression2.evalAsString(focus, evalContext);
        int n = Matches.convertFlags(string2);
        if (n < 0) {
            evalContext.error(expression2, "illegal regular expression flags");
        }
        try {
            Pattern pattern = Pattern.compile(string, n);
            if (!bl && pattern.matcher("").matches()) {
                evalContext.error(expression, "pattern matches empty string");
            }
            return pattern;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            evalContext.error(expression, "invalid regular expression: " + patternSyntaxException.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.BoolCall {
        Pattern precompiled = null;

        public void compilationHook() {
            Expression expression = this.args.length < 3 ? null : this.args[2];
            this.precompiled = Matches.precompileRegexp(this.args[1], expression, true);
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.args[0].evalAsOptString(focus, evalContext);
            if (string == null) {
                string = "";
            }
            evalContext.at(this);
            Expression expression = this.args.length < 3 ? null : this.args[2];
            Pattern pattern = this.precompiled != null ? this.precompiled : Matches.compileRegexp(this.args[1], expression, true, focus, evalContext);
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }
    }
}

