/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.time.DateTime;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

public class GetSecondsFromDateTime
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("get-seconds-from-dateTime", Type.DOUBLE.opt, class$net$xfra$qizxopen$xquery$fn$GetSecondsFromDateTime$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$GetSecondsFromDateTime$Exec = GetSecondsFromDateTime.class$("net.xfra.qizxopen.xquery.fn.GetSecondsFromDateTime$Exec")) : class$net$xfra$qizxopen$xquery$fn$GetSecondsFromDateTime$Exec).arg("op", (Type)Type.DATE_TIME.opt)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$GetSecondsFromDateTime$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.DoubleCall {
        public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            evalContext.at(this);
            Item item = this.args[0].evalAsOptItem(focus, evalContext);
            if (item == null) {
                throw EmptyException.allowed();
            }
            if (item instanceof MomentValue) {
                MomentValue momentValue = (MomentValue)item;
                return momentValue.getValue().getSecond();
            }
            try {
                DateTime dateTime = DateTime.parseDateTime(item.asString(), evalContext.getImplicitTimezone());
                return dateTime.getSecond();
            }
            catch (DateTimeException dateTimeException) {
                evalContext.error((Expression)this, "cannot cast to xs:dateTime : " + dateTimeException.getMessage());
                return 0.0;
            }
        }
    }
}

