/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.text.Collator;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.StringValue;

public abstract class QNameValue
extends BaseValue {
    public QNameValue() {
        this.itemType = Type.QNAME;
    }

    public abstract QName getValue();

    public Item asItem() {
        return this;
    }

    public String asString() {
        return "expanded-QName(\"" + this.getValue().getURI() + "\", \"" + this.getValue().getLocalName() + "\")";
    }

    public boolean equals(Object object) {
        if (!(object instanceof QNameValue)) {
            return false;
        }
        return this.getValue() == ((QNameValue)object).getValue();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public int compareTo(Item item, Collator collator, int n) {
        if (!Type.QNAME.accepts(item.getType())) {
            return 2;
        }
        QName qName = this.getValue();
        QName qName2 = ((QNameValue)item).getValue();
        int n2 = StringValue.compare(qName.getURI(), qName2.getURI(), null);
        if (n2 != 0) {
            return n2;
        }
        return StringValue.compare(qName.getLocalName(), qName2.getLocalName(), null);
    }
}

