/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.AtomicType;
import net.xfra.qizxopen.xquery.dt.DurationValue;
import net.xfra.qizxopen.xquery.dt.SingleDuration;
import net.xfra.qizxopen.xquery.dt.StringType;

public class DurationType
extends AtomicType {
    public String getShortName() {
        return "duration";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        Duration duration;
        block4: {
            ItemType itemType = value.getType();
            duration = null;
            try {
                if (itemType instanceof StringType) {
                    duration = Duration.parseDuration(value.asString());
                    break block4;
                }
                if (itemType instanceof DurationType) {
                    duration = ((DurationValue)value).getValue();
                    break block4;
                }
                throw new DateTimeException("invalid type " + itemType);
            }
            catch (DateTimeException dateTimeException) {
                throw new TypeException("cannot cast to xs:duration : " + dateTimeException.getMessage());
            }
        }
        return new SingleDuration(duration, Type.DURATION);
    }
}

