/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.math.BigDecimal;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.NumericType;
import net.xfra.qizxopen.xquery.dt.SingleDecimal;
import net.xfra.qizxopen.xquery.dt.StringType;

public class DecimalType
extends NumericType {
    public String getShortName() {
        return "decimal";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        BigDecimal bigDecimal;
        ItemType itemType = value.getType();
        try {
            if (itemType instanceof StringType || Type.UNTYPED_ATOMIC.accepts(itemType)) {
                bigDecimal = Conversion.toDecimal(value.asString());
            } else if (Type.INTEGER.accepts(itemType)) {
                bigDecimal = new BigDecimal(value.asString());
            } else if (Type.NUMERIC.accepts(itemType)) {
                bigDecimal = new BigDecimal(value.asDouble());
            } else {
                throw new TypeException("invalid type " + itemType);
            }
            if (bigDecimal.scale() < 1) {
                bigDecimal = bigDecimal.setScale(1);
            }
        }
        catch (TypeException typeException) {
            throw new TypeException("cannot cast to xs:decimal : " + typeException.getMessage());
        }
        return new SingleDecimal(bigDecimal);
    }
}

