/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.Date;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.MomentType;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.NodeType;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.dt.StringType;

public class DateType
extends MomentType {
    public String getShortName() {
        return "date";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        Date date;
        block4: {
            ItemType itemType = value.getType();
            date = null;
            try {
                if (itemType instanceof StringType || itemType instanceof NodeType) {
                    date = Date.parseDate(value.asString(), evalContext.getImplicitTimezone());
                    break block4;
                }
                if (itemType == Type.DATE || itemType == Type.DATE_TIME) {
                    date = new Date(((MomentValue)value).getValue());
                    break block4;
                }
                throw new DateTimeException("invalid type " + itemType);
            }
            catch (DateTimeException dateTimeException) {
                throw new TypeException("cannot cast to xs:date : " + dateTimeException.getMessage());
            }
        }
        return new SingleMoment(date, Type.DATE);
    }
}

