/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dm;

import java.math.BigDecimal;
import java.text.Collator;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.UntypedAtomicType;

public abstract class NodeBase
implements Node {
    public ItemType getType() {
        return Type.NODE;
    }

    public boolean isNode() {
        return true;
    }

    public boolean asBoolean() throws TypeException {
        return this.asString().length() != 0;
    }

    public long asInteger() throws TypeException {
        return Conversion.toInteger(this.asString());
    }

    public BigDecimal asDecimal() throws TypeException {
        return Conversion.toDecimal(this.asString());
    }

    public float asFloat() throws TypeException {
        return Conversion.toFloat(this.asString());
    }

    public double asDouble() throws TypeException {
        return Conversion.toDouble(this.asString());
    }

    public String asString() throws TypeException {
        return this.getStringValue();
    }

    public Node asNode() throws TypeException {
        return this;
    }

    public Item asItem() throws TypeException {
        return this;
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        return UntypedAtomicType.comparison(this, item, collator);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Node)) {
            return false;
        }
        return this.orderCompare((Node)object) == 0;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

