/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dm;

import java.math.BigDecimal;
import java.text.Collator;
import net.xfra.qizxopen.dm.FONIDM;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.NodeSequenceBase;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.NodeType;
import net.xfra.qizxopen.xquery.dt.UntypedAtomicType;

public class FONIDataModel
extends FONIDM {
    public FONIDataModel(FONIDocument fONIDocument) {
        super(fONIDocument);
        this.root = this.newNode(fONIDocument.getRootNode());
    }

    public Node getDocumentNode() {
        return (Node)this.root;
    }

    public Node newNode(int n) {
        if (n == 0) {
            return null;
        }
        return new INode(n);
    }

    public net.xfra.qizxopen.dm.Node newDmNode(int n) {
        return this.newNode(n);
    }

    class Attributes
    extends ASequence {
        NodeTest nodeTest;
        int nameId = -1;

        Attributes(int n, NodeTest nodeTest) {
            super(n, FONIDataModel.this.dom.attrIterator(n));
            this.nodeTest = nodeTest;
        }

        boolean checkNode() {
            if (this.curId == 0) {
                return false;
            }
            return this.nodeTest == null || (this.nodeTest.needsNode() ? this.nodeTest.accepts(this.makeNode(this.curId)) : this.nodeTest.accepts(3, FONIDataModel.this.dom.pnGetName(this.curId)));
        }

        public Value bornAgain() {
            return new Attributes(this.ownerId, this.nodeTest);
        }

        public boolean next() {
            while (super.next()) {
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class ASequence
    extends NodeSequenceBase {
        FONIDocument.NodeIterator domIter;
        int ownerId;
        int curId;

        ASequence(int n, FONIDocument.NodeIterator nodeIterator) {
            this.domIter = nodeIterator;
            this.ownerId = n;
        }

        public boolean next() {
            if (!this.domIter.next()) {
                return false;
            }
            this.curId = this.domIter.currentId();
            return true;
        }

        public Node asNode() {
            this.curId = this.domIter.currentId();
            return this.curId == 0 ? null : this.makeNode(this.curId);
        }

        public ItemType getType() {
            return Type.ATTRIBUTE;
        }

        ANode makeNode(int n) {
            return new ANode(this.ownerId, n);
        }

        public Value bornAgain() {
            return new ASequence(this.ownerId, this.domIter.reborn());
        }
    }

    class Preceding
    extends PrecedingSiblings {
        Preceding(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.curId = FONIDataModel.this.dom.getRootNode();
        }

        public Value bornAgain() {
            return new Preceding(this.startId, this.nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDataModel.this.dom.getNodeNext(this.curId);
                }
                this.started = true;
                if (this.curId == this.startId) {
                    this.curId = 0;
                    return false;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class PrecedingSiblings
    extends TypedSequence {
        PrecedingSiblings(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.curId = FONIDataModel.this.dom.getFirstChild(FONIDataModel.this.dom.getParent(n));
        }

        public Value bornAgain() {
            return new PrecedingSiblings(this.startId, this.nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDataModel.this.dom.getNextSibling(this.curId);
                }
                this.started = true;
                if (this.curId == this.startId) {
                    this.curId = 0;
                    return false;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Following
    extends TypedSequence {
        Following(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public Value bornAgain() {
            return new Following(this.startId, this.nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                this.curId = FONIDataModel.this.dom.getNodeNext(this.curId);
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class FollowingSiblings
    extends TypedSequence {
        FollowingSiblings(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public Value bornAgain() {
            return new FollowingSiblings(this.startId, this.nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                this.curId = FONIDataModel.this.dom.getNextSibling(this.curId);
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Descendants
    extends DescendantsOrSelf {
        Descendants(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.started = true;
        }

        public Value bornAgain() {
            return new Descendants(this.startId, this.nodeTest);
        }
    }

    class DescendantsOrSelf
    extends TypedSequence {
        int lastNode;

        DescendantsOrSelf(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.lastNode = FONIDataModel.this.dom.getNodeAfter(Math.abs(n));
            if (this.lastNode == 0) {
                this.lastNode = Integer.MAX_VALUE;
            }
        }

        public Value bornAgain() {
            return new DescendantsOrSelf(this.startId, this.nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDataModel.this.dom.getNodeNext(this.curId);
                }
                this.started = true;
                if (this.curId >= this.lastNode) {
                    this.curId = 0;
                    continue;
                }
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Children
    extends TypedSequence {
        Children(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.curId = FONIDataModel.this.dom.getFirstChild(n);
        }

        public Value bornAgain() {
            return new Children(this.startId, this.nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDataModel.this.dom.getNextSibling(this.curId);
                }
                this.started = true;
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }
    }

    class Ancestors
    extends AncestorsOrSelf {
        Ancestors(int n, NodeTest nodeTest) {
            super(n, nodeTest);
            this.started = true;
        }

        public Value bornAgain() {
            return new Ancestors(this.startId, this.nodeTest);
        }
    }

    class AncestorsOrSelf
    extends TypedSequence {
        AncestorsOrSelf(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public boolean next() {
            while (this.curId != 0) {
                if (this.started) {
                    this.curId = FONIDataModel.this.dom.getParent(this.curId);
                }
                this.started = true;
                if (!this.checkNode()) continue;
                return true;
            }
            return false;
        }

        public Value bornAgain() {
            return new AncestorsOrSelf(this.startId, this.nodeTest);
        }
    }

    class Parent
    extends TypedSequence {
        Parent(int n, NodeTest nodeTest) {
            super(n, nodeTest);
        }

        public boolean next() {
            if (this.started) {
                return false;
            }
            this.started = true;
            this.curId = FONIDataModel.this.dom.getParent(this.curId);
            return this.checkNode();
        }

        public Value bornAgain() {
            return new Parent(this.startId, this.nodeTest);
        }
    }

    abstract class TypedSequence
    extends ISequence {
        NodeTest nodeTest;
        int nameId = -1;
        boolean started = false;

        TypedSequence(int n, NodeTest nodeTest) {
            super(n);
            this.nodeTest = nodeTest;
        }

        boolean checkNode() {
            if (this.curId == 0) {
                return false;
            }
            return this.nodeTest == null || (this.nodeTest.needsNode() ? this.nodeTest.accepts(FONIDataModel.this.newNode(this.curId)) : this.nodeTest.accepts(FONIDataModel.this.dom.getKind(this.curId), FONIDataModel.this.dom.getName(this.curId)));
        }
    }

    class ISequence
    extends NodeSequenceBase {
        int startId;
        int curId;

        ISequence(int n) {
            this.curId = this.startId = n;
        }

        public Value bornAgain() {
            return new ISequence(this.startId);
        }

        public boolean next() {
            this.curId = this.curId < 0 ? -this.curId : FONIDataModel.this.dom.getNextSibling(this.curId);
            return this.curId != 0;
        }

        public int currentId() {
            return this.curId;
        }

        public Node asNode() {
            return this.curId == 0 ? null : FONIDataModel.this.newNode(this.curId);
        }

        public ItemType getType() {
            return NodeType.getTypeByKind(FONIDataModel.this.dom.getKind(this.curId));
        }
    }

    class NSNode
    extends ANode {
        NSNode(int n, int n2) {
            super(n, n2);
        }

        public String getNodeKind() {
            return "namespace";
        }

        public int getNature() {
            return 7;
        }

        public ItemType getType() {
            return Type.NAMESPACE;
        }
    }

    class ANode
    extends INode {
        int offset;

        ANode(int n, int n2) {
            super(n);
            this.offset = n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ANode)) {
                return false;
            }
            ANode aNode = (ANode)object;
            return aNode.id == this.id && aNode.offset == this.offset && aNode.getDom() == FONIDataModel.this.dom;
        }

        public int hashCode() {
            return this.id ^ this.offset;
        }

        public int orderCompare(Node node) {
            int n = super.orderCompare(node);
            if (n != 0) {
                return n;
            }
            if (!(node instanceof ANode)) {
                return 1;
            }
            ANode aNode = (ANode)node;
            n = this.offset - aNode.offset;
            return n < 0 ? -1 : (n > 0 ? 1 : 0);
        }

        public int getNature() {
            return 3;
        }

        public String getNodeKind() {
            return "attribute";
        }

        public ItemType getType() {
            return Type.ATTRIBUTE;
        }

        public QName getNodeName() {
            return FONIDataModel.this.dom.getOtherName(FONIDataModel.this.dom.pnGetNameId(this.offset));
        }

        public String getStringValue() {
            return FONIDataModel.this.dom.pnGetStringValue(this.offset);
        }

        public Node getParent() {
            return FONIDataModel.this.newNode(this.id);
        }

        public Value getChildren() {
            return Value.empty;
        }

        public Value getAttributes() {
            return Value.empty;
        }

        public Value getNamespaces() {
            return Value.empty;
        }
    }

    class INode
    extends FONIDM.BaseNode
    implements Node {
        INode(int n) {
            super(FONIDataModel.this, n);
        }

        public ItemType getType() {
            return NodeType.getTypeByKind(FONIDataModel.this.dom.getKind(this.id));
        }

        public Node getParent() {
            return FONIDataModel.this.newNode(FONIDataModel.this.dom.getParent(this.id));
        }

        public Value getTypedValue() {
            return null;
        }

        public Value getChildren() {
            return new ISequence(-FONIDataModel.this.dom.getFirstChild(this.id));
        }

        public Value getAttributes() {
            return new ASequence(this.id, FONIDataModel.this.dom.attrIterator(this.id));
        }

        public Value getNamespaces(boolean bl) {
            return new ASequence(this, this.id, FONIDataModel.this.dom.namespaceIterator(this.id, bl)){
                private final /* synthetic */ INode this$1;
                {
                    this.this$1 = iNode;
                }

                ANode makeNode(int n) {
                    return INode.access$500(this.this$1).new NSNode(this.ownerId, n);
                }
            };
        }

        public boolean deepEqual(Item item, Collator collator) {
            if (!(item instanceof Node)) {
                return false;
            }
            try {
                return this.deepEq(this.id, (Node)item, collator);
            }
            catch (Exception exception) {
                return false;
            }
        }

        public int compareTo(Item item, Collator collator, int n) throws TypeException {
            return UntypedAtomicType.comparison(this, item, collator);
        }

        public Node getDocument() {
            return FONIDataModel.this.newNode(FONIDataModel.this.dom.getRootNode());
        }

        public Node getAttribute(QName qName) {
            return FONIDataModel.this.newNode(FONIDataModel.this.dom.getAttribute(this.id, FONIDataModel.this.dom.internOtherName(qName)));
        }

        public Value getAncestors(NodeTest nodeTest) {
            return new AncestorsOrSelf(this.id, nodeTest);
        }

        public Value getAncestorsOrSelf(NodeTest nodeTest) {
            return new AncestorsOrSelf(this.id, nodeTest);
        }

        public Value getParent(NodeTest nodeTest) {
            return new Parent(this.id, nodeTest);
        }

        public Value getChildren(NodeTest nodeTest) {
            return new Children(this.id, nodeTest);
        }

        public Value getDescendants(NodeTest nodeTest) {
            return new Descendants(this.id, nodeTest);
        }

        public Value getDescendantsOrSelf(NodeTest nodeTest) {
            return new DescendantsOrSelf(this.id, nodeTest);
        }

        public Value getAttributes(NodeTest nodeTest) {
            return new Attributes(this.id, nodeTest);
        }

        public Value getFollowingSiblings(NodeTest nodeTest) {
            return new FollowingSiblings(this.id, nodeTest);
        }

        public Value getPrecedingSiblings(NodeTest nodeTest) {
            return new PrecedingSiblings(this.id, nodeTest);
        }

        public Value getFollowing(NodeTest nodeTest) {
            return new Following(this.id, nodeTest);
        }

        public Value getPreceding(NodeTest nodeTest) {
            return new Preceding(this.id, nodeTest);
        }

        public boolean isNode() {
            return true;
        }

        public Node asNode() throws TypeException {
            return this;
        }

        public Item asItem() throws TypeException {
            return this;
        }

        public String asString() throws TypeException {
            return this.getStringValue();
        }

        public boolean asBoolean() throws TypeException {
            return this.asString().length() != 0;
        }

        public long asInteger() throws TypeException {
            return Conversion.toInteger(this.asString());
        }

        public BigDecimal asDecimal() throws TypeException {
            return Conversion.toDecimal(this.asString());
        }

        public float asFloat() throws TypeException {
            return Conversion.toFloat(this.asString());
        }

        public double asDouble() throws TypeException {
            return Conversion.toDouble(this.asString());
        }

        static /* synthetic */ FONIDataModel access$500(INode iNode) {
            return iNode.FONIDataModel.this;
        }
    }
}

