/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.Collator;
import java.util.HashMap;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Timer;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.xquery.DocumentManager;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.Query;
import net.xfra.qizxopen.xquery.SyntaxException;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.impl.DefaultEvalContext;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.impl.Parser;
import net.xfra.qizxopen.xquery.impl.PredefinedModule;
import net.xfra.qizxopen.xquery.impl.Version;

public class XQueryProcessor {
    public static String EXTENSIONS_URI = "net.xfra.qizxopen.ext.Qizx";
    public static Namespace EXTENSIONS_NS = Namespace.get(EXTENSIONS_URI);
    static PredefinedModule QizxPredefined = XQueryProcessor.newQizxPredefinedModule();
    protected DocumentManager docMan;
    protected ModuleManager moduleMan;
    protected String baseURI = ".";
    protected Value input;
    protected PredefinedModule predefined = QizxPredefined;
    protected HashMap globals = new HashMap();
    protected HashMap collations;
    protected HashMap properties = new HashMap();
    protected String defaultCollation = null;
    protected String implicitTimezone = null;
    protected PrintWriter defaultOutput = new PrintWriter(System.out, true);
    protected Log log;
    protected NSPrefixMapping extraNS;

    public XQueryProcessor() {
        this.init();
    }

    public XQueryProcessor(String string, String string2) throws IOException {
        this.setDocumentManager(new DocumentManager(string2));
        this.setModuleManager(new ModuleManager(string));
        this.init();
    }

    public XQueryProcessor(XQueryProcessor xQueryProcessor) {
        this.docMan = xQueryProcessor.getDocumentManager();
        this.moduleMan = xQueryProcessor.getModuleManager();
        this.predefined = xQueryProcessor.predefined;
        this.collations = xQueryProcessor.collations;
        this.defaultCollation = xQueryProcessor.defaultCollation;
        this.implicitTimezone = xQueryProcessor.implicitTimezone;
        this.properties = (HashMap)xQueryProcessor.properties.clone();
        this.extraNS = xQueryProcessor.extraNS == null ? null : xQueryProcessor.extraNS.copy();
        this.setSysProperty(":processor", this);
    }

    private void init() {
        this.predefineNamespace("qizx", EXTENSIONS_NS.getURI());
        this.predefineNamespace("x", EXTENSIONS_NS.getURI());
        this.setSysProperty(":processor", this);
        this.setSysProperty("version", "1.0");
        this.setSysProperty("vendor", "Xavier Franc");
        this.setSysProperty("vendor-url", "http://www.xfra.net/qizxopen/");
        this.setSysProperty("product-name", "Qizx/open");
        this.setSysProperty("product-version", Version.get());
    }

    public String getVersion() {
        return Version.get();
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleMan = moduleManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleMan;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.docMan = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.docMan;
    }

    public void setDocumentInput(String string) throws XQueryException {
        if (this.docMan == null) {
            throw new EvalException("no Document Manager defined");
        }
        this.setInput(this.docMan.findDocument(string));
    }

    public void setCollectionInput(String string) {
        throw new RuntimeException("no setCollectionInput! " + string);
    }

    public void setInput(Node node) {
        this.input = new SingleNode(node);
    }

    public void setDefaultOutput(PrintWriter printWriter) {
        this.defaultOutput = printWriter;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setSysProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getSysProperty(String string) {
        return this.properties.get(string);
    }

    public void resetDeclarations() {
        this.predefined = QizxPredefined;
        this.globals = new HashMap();
    }

    public void predefineGlobal(QName qName, Type type) {
        if (this.predefined == QizxPredefined) {
            this.predefined = XQueryProcessor.newQizxPredefinedModule();
        }
        this.predefined.defineGlobal(qName, type);
    }

    private static PredefinedModule newQizxPredefinedModule() {
        PredefinedModule predefinedModule = new PredefinedModule();
        predefinedModule.registerFunctionPlugger(new PredefinedModule.BasicFunctionPlugger(EXTENSIONS_NS, EXTENSIONS_URI + "%C"));
        return predefinedModule;
    }

    public void predefineGlobal(String string, Type type) {
        this.predefineGlobal(QName.get(Module.LOCAL_NS, string), type);
    }

    public void initGlobal(QName qName, Value value) {
        this.globals.put(qName, value);
    }

    public static QName toLocalNS(String string) {
        return QName.get(Module.LOCAL_NS, string);
    }

    public void initGlobal(QName qName, boolean bl) {
        this.initGlobal(qName, new SingleBoolean(bl));
    }

    public void initGlobal(QName qName, long l) {
        this.initGlobal(qName, new SingleInteger(l));
    }

    public void initGlobal(QName qName, double d) {
        this.initGlobal(qName, new SingleDouble(d));
    }

    public void initGlobal(QName qName, String string) {
        this.initGlobal(qName, new SingleString(string));
    }

    public void initGlobal(QName qName, String[] stringArray) {
        Object[] objectArray = new SingleString[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            objectArray[n] = new SingleString(stringArray[n]);
            ++n;
        }
        this.initGlobal(qName, new ArraySequence(objectArray, objectArray.length));
    }

    public void initGlobal(QName qName, Object object) {
        this.initGlobal(qName, new SingleWrappedObject(object));
    }

    public void predefineNamespace(String string, String string2) {
        if (this.extraNS == null) {
            this.extraNS = new NSPrefixMapping();
        }
        this.extraNS.addMapping(string, string2);
    }

    public void registerCollation(String string, Collator collator) {
        if (this.collations == null) {
            this.collations = new HashMap();
        }
        this.collations.put(string, collator);
    }

    public void setDefaultCollation(String string) {
        this.defaultCollation = string;
    }

    public void setImplicitTimezone(String string) {
        this.implicitTimezone = string;
    }

    public void authorizeClass(String string) {
        this.predefined.authorizeJavaClass(string);
    }

    public Query compileQuery(CharSequence charSequence, String string, Log log) throws XQueryException {
        if (charSequence == null) {
            throw new IllegalArgumentException("null textInput");
        }
        if (string == null) {
            throw new IllegalArgumentException("null URI");
        }
        if (log == null) {
            throw new IllegalArgumentException("null log");
        }
        if (this.moduleMan == null) {
            throw new XQueryException("no Module Manager specified");
        }
        if (this.docMan == null) {
            throw new XQueryException("no Document Manager specified");
        }
        Parser parser = new Parser(this.moduleMan);
        parser.setPredefinedModule(this.predefined);
        parser.setCollations(this.collations);
        if (this.extraNS != null) {
            parser.setPredefinedNamespaces(this.extraNS);
        }
        try {
            int n = log.getErrorCount();
            Query query = parser.parseQuery(charSequence, string, log);
            query.setBaseURI(this.docMan.getBaseURI());
            int n2 = log.getErrorCount() - n;
            if (n2 == 0) {
                query.staticCheck(this.moduleMan, log);
            }
            log.flush();
            n2 = log.getErrorCount() - n;
            if (n2 > 0) {
                throw new XQueryException("static analysis: " + n2 + " error" + (n2 > 1 ? "s" : ""));
            }
            return query;
        }
        catch (SyntaxException syntaxException) {
            throw new XQueryException("syntax: " + syntaxException.getMessage());
        }
    }

    public Query compileQuery(Reader reader, String string, Log log) throws XQueryException, IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.compileQuery(stringBuffer, string, log);
    }

    public Query compileQuery(File file, Log log) throws XQueryException, IOException {
        return this.compileQuery(new FileReader(file), file.getAbsolutePath(), log);
    }

    private DefaultEvalContext prepareQuery(Query query) throws XQueryException {
        if (query == null) {
            throw new IllegalArgumentException("null query");
        }
        if (this.docMan == null) {
            throw new EvalException("no Document Manager defined");
        }
        DefaultEvalContext defaultEvalContext = new DefaultEvalContext(query, query.getLocalSize());
        defaultEvalContext.setProperties(this.properties);
        defaultEvalContext.setDocumentManager(this.docMan);
        defaultEvalContext.setDefaultOutput(this.defaultOutput);
        defaultEvalContext.setLog(this.log);
        try {
            if (this.implicitTimezone != null) {
                defaultEvalContext.setImplicitTimezone(this.implicitTimezone);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new XQueryException("implicit timezone: " + dateTimeException.getMessage());
        }
        if (this.defaultCollation != null) {
            query.setDefaultCollation(this.defaultCollation);
        }
        if (this.input != null) {
            defaultEvalContext.setInput(this.input);
        }
        query.initGlobals(defaultEvalContext, this.globals);
        Integer n = (Integer)this.getSysProperty(":timeout");
        if (n != null) {
            final DefaultEvalContext defaultEvalContext2 = defaultEvalContext;
            Timer.request(n, new Timer.Handler(){

                public void timeEvent(Timer.Request request) {
                    defaultEvalContext2.timeOut(true);
                }
            });
        }
        return defaultEvalContext;
    }

    public Value executeQuery(Query query) throws XQueryException {
        DefaultEvalContext defaultEvalContext = this.prepareQuery(query);
        return query.eval(null, defaultEvalContext);
    }

    public void executeQuery(Query query, XMLEventReceiver xMLEventReceiver) throws XQueryException {
        DefaultEvalContext defaultEvalContext = this.prepareQuery(query);
        xMLEventReceiver.reset();
        xMLEventReceiver.definePrefixHints(query.getInScopeNS());
        try {
            query.evalAsEvents(xMLEventReceiver, null, defaultEvalContext);
            xMLEventReceiver.terminate();
        }
        catch (DataModelException dataModelException) {
            defaultEvalContext.error(query.body, new EvalException(dataModelException.getMessage(), dataModelException));
        }
    }

    public void executeQuery(Query query, Writer writer) throws XQueryException {
        XMLSerializer xMLSerializer = new XMLSerializer();
        xMLSerializer.setOutput(writer);
        this.executeQuery(query, xMLSerializer);
    }
}

