/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import java.io.PrintWriter;
import java.util.Vector;
import net.xfra.qizxopen.xquery.impl.Module;

public class Log {
    static final int INFO = 0;
    static final int TRACE = 1;
    static final int WARNING = 2;
    static final int ERROR = 3;
    protected int errorCount = 0;
    protected Vector messages = new Vector();
    protected PrintWriter output;
    protected boolean printSource = true;

    public Log() {
        this(new PrintWriter(System.err, true));
    }

    public Log(PrintWriter printWriter) {
        this.output = printWriter;
    }

    public void reset() {
        this.flush();
        this.messages.setSize(0);
        this.errorCount = 0;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public Message getMessage(int n) {
        return n < 0 || n >= this.messages.size() ? null : (Message)this.messages.get(n);
    }

    public void flush() {
        this.output.flush();
    }

    public void error(Module module, int n, String string, String[] stringArray) {
        ++this.errorCount;
        Message message = new Message(module, n, 3, string, stringArray);
        this.printMessage(message);
        this.messages.add(message);
    }

    public void error(Module module, int n, String string) {
        this.error(module, n, string, new String[0]);
    }

    public void error(Module module, int n, String string, String string2) {
        this.error(module, n, string, new String[]{string2});
    }

    public void error(Module module, int n, String string, String string2, String string3) {
        this.error(module, n, string, new String[]{string2, string3});
    }

    public void warning(Module module, int n, String string, String[] stringArray) {
        Message message = new Message(module, n, 2, string, stringArray);
        this.printMessage(message);
        this.messages.add(message);
    }

    public void warning(Module module, int n, String string, String string2) {
        this.warning(module, n, string, new String[]{string2});
    }

    public void trace(Module module, int n, String string, String[] stringArray) {
        Message message = new Message(module, n, 1, string, stringArray);
        this.printMessage(message);
        this.messages.add(message);
    }

    public void info(String string) {
        Message message = new Message(null, 0, 0, string, null);
        this.printMessage(message);
        this.messages.add(message);
    }

    public void printMessage(Message message) {
        if (message.severity != 0) {
            CharSequence charSequence;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(message.severity == 3 ? "*** " : (message.severity == 2 ? "* warning " : "-- trace "));
            if (message.module == null) {
                stringBuffer.append("at start of input, ");
            } else if (message.module.getPhysicalURI() != null) {
                stringBuffer.append("in " + message.module.getPhysicalURI() + ", ");
            }
            CharSequence charSequence2 = charSequence = message.module == null ? null : message.module.getSource();
            if (charSequence != null) {
                stringBuffer.append("at line " + Log.getLineNumber(charSequence, message.location));
            } else {
                stringBuffer.append("at char offset " + message.location);
            }
            stringBuffer.append(": ");
            stringBuffer.append(message.expand());
            this.println(stringBuffer.toString());
            if (this.printSource && message.severity != 1 && message.module != null) {
                this.println(Log.getLine(charSequence, message.location));
                stringBuffer.setLength(0);
                int n = Log.getColumn(charSequence, message.location);
                while (--n >= 0) {
                    stringBuffer.append('-');
                }
                stringBuffer.append('^');
                this.println(stringBuffer.toString());
            }
        } else {
            this.println("  " + message.message);
        }
        this.output.flush();
    }

    protected void println(String string) {
        this.output.println(string);
    }

    public static int getLineNumber(CharSequence charSequence, int n) {
        int n2 = 1;
        int n3 = n;
        while (--n3 >= 0) {
            if (charSequence.charAt(n3) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public static int getColumn(CharSequence charSequence, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (charSequence.charAt(n2) == '\n') break;
        }
        return n - n2 - 1;
    }

    public static String getLine(CharSequence charSequence, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            if (charSequence.charAt(n2) == '\n') break;
        }
        int n3 = ++n2;
        int n4 = charSequence.length();
        while (n3 < n4) {
            if (charSequence.charAt(n3) == '\n') break;
            ++n3;
        }
        return charSequence.subSequence(n2, n3).toString();
    }

    public static class Message {
        int severity;
        Module module;
        int location;
        String message;
        String[] arguments;

        Message(Module module, int n, int n2, String string, String[] stringArray) {
            this.module = module;
            this.severity = n2;
            this.location = n;
            this.message = string;
            this.arguments = stringArray;
        }

        String expand() {
            StringBuffer stringBuffer = new StringBuffer(this.message.length());
            int n = 0;
            int n2 = this.message.length();
            while (n < n2) {
                char c = this.message.charAt(n);
                if (c != '%') {
                    stringBuffer.append(c);
                } else if ((c = this.message.charAt(++n)) < '1' || c > '9') {
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(this.arguments[c - 49]);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

