/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import com.sun.resolver.CatalogManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.xfra.qizxopen.dm.IDocument;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.dm.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentManager {
    protected SAXParserFactory factory;
    protected URL baseURL;
    protected EntityResolver entityResolver;
    static final int MIN_CACHE_SIZE = 131072;
    private static final String CACHE_SIZE_PROP = "qizx.docman.cachesize";
    private long cacheSize = 0x800000L;
    private Vector cache = new Vector();
    static final String SAXLEX = "http://xml.org/sax/properties/lexical-handler";

    public DocumentManager(URL uRL) {
        this.init(uRL);
    }

    public DocumentManager(String string) throws IOException {
        this.init(Util.uriToURL(string));
    }

    public String getBaseURI() {
        return this.baseURL.toString();
    }

    public void setCacheSize(long l) {
        this.cacheSize = Math.max(l, 131072L);
    }

    private void init(URL uRL) {
        block4: {
            Object object;
            this.baseURL = uRL;
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(true);
            System.setProperty("entityExpansionLimit", "1000000000");
            try {
                object = Class.forName("com.sun.resolver.tools.CatalogResolver");
                CatalogManager.ignoreMissingProperties((boolean)true);
                this.entityResolver = (EntityResolver)((Class)object).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = System.getProperty(CACHE_SIZE_PROP);
            if (object == null) break block4;
            try {
                this.setCacheSize(Long.parseLong((String)object));
            }
            catch (Exception exception) {}
        }
    }

    protected synchronized FONIDataModel getCachedDocument(String string) {
        int n = 0;
        int n2 = this.cache.size();
        while (n < n2) {
            FONIDataModel fONIDataModel = (FONIDataModel)this.cache.get(n);
            if (string.equals(fONIDataModel.getDocumentURI())) {
                this.cache.remove(n);
                this.cache.insertElementAt(fONIDataModel, 0);
                return fONIDataModel;
            }
            ++n;
        }
        return null;
    }

    protected synchronized void cacheDocument(FONIDataModel fONIDataModel) {
        if (!this.cache.contains(fONIDataModel)) {
            this.cache.insertElementAt(fONIDataModel, 0);
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.cache.size();
        while (n2 < n3) {
            FONIDataModel fONIDataModel2 = (FONIDataModel)this.cache.get(n2);
            int n4 = fONIDataModel2.estimateMemorySize();
            if ((long)(n + n4) > this.cacheSize) {
                this.cache.setSize(n2);
                break;
            }
            n += n4;
            ++n2;
        }
    }

    protected URL resolveLocation(String string) throws IOException {
        return new URL(this.baseURL, string);
    }

    public Node findDocument(String string) throws EvalException {
        try {
            URL uRL = this.resolveLocation(string);
            FONIDataModel fONIDataModel = this.getCachedDocument(uRL.toString());
            if (fONIDataModel == null) {
                try {
                    fONIDataModel = this.parseDocument(uRL);
                }
                catch (SAXException sAXException) {
                    throw new EvalException("XML parsing error in " + string + ": " + sAXException.getMessage(), sAXException.getException());
                }
            }
            if (fONIDataModel == null) {
                throw new EvalException(string + " (document cannot be located)");
            }
            this.cacheDocument(fONIDataModel);
            return fONIDataModel.getDocumentNode();
        }
        catch (IOException iOException) {
            throw new EvalException("document IO error on: " + string, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FONIDataModel parseDocument(URL uRL) throws SAXException, IOException {
        InputStream inputStream = uRL.openStream();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        FONIDataModel fONIDataModel = null;
        try {
            fONIDataModel = this.parseDocument(inputSource);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return fONIDataModel;
    }

    public FONIDataModel parseDocument(InputSource inputSource) throws SAXException, IOException {
        try {
            SAXParser sAXParser = this.factory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            IDocument iDocument = new IDocument();
            try {
                xMLReader.setProperty(SAXLEX, iDocument);
            }
            catch (Exception exception) {
                System.err.println("*** lexical-handler: " + exception);
            }
            if (this.entityResolver != null) {
                xMLReader.setEntityResolver(this.entityResolver);
            } else {
                xMLReader.setEntityResolver(iDocument);
            }
            xMLReader.setDTDHandler(iDocument);
            xMLReader.setContentHandler(iDocument);
            xMLReader.setErrorHandler(iDocument);
            long l = System.currentTimeMillis();
            xMLReader.parse(inputSource);
            return new FONIDataModel(iDocument);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
    }
}

