/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util.time;

import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.util.time.DateTimeException;

public class Duration {
    private boolean negative;
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private double second;

    public static Duration parseDuration(String string) throws DateTimeException {
        int n;
        int n2 = string.length();
        if (n2 <= 1) {
            throw new DateTimeException("duration syntax", string);
        }
        Duration duration = new Duration();
        int n3 = 0;
        if (string.charAt(0) == '-') {
            duration.negative = true;
            ++n3;
        }
        if (n3 + 2 >= n2 || string.charAt(n3) != 'P') {
            throw new DateTimeException("duration syntax", string);
        }
        boolean bl = false;
        boolean bl2 = false;
        int n4 = string.indexOf(84);
        if ((n = string.indexOf(89, ++n3)) > n3) {
            duration.year = DateTimeBase.parseNonNegativeInt(string, n3, n);
            bl = true;
            n3 = n + 1;
        }
        if ((n = string.indexOf(77, n3)) > n3 && (n4 < 0 || n < n4)) {
            duration.month = DateTimeBase.parseNonNegativeInt(string, n3, n);
            bl = true;
            n3 = n + 1;
        }
        if ((n = string.indexOf(68, n3)) > n3) {
            duration.day = DateTimeBase.parseNonNegativeInt(string, n3, n);
            bl = true;
            n3 = n + 1;
        }
        if (n4 >= 0) {
            if (n4 == n3) {
                if ((n = string.indexOf(72, ++n3)) > n3) {
                    duration.hour = DateTimeBase.parseNonNegativeInt(string, n3, n);
                    bl2 = true;
                    n3 = n + 1;
                }
                if ((n = string.indexOf(77, n3)) > n3) {
                    duration.minute = DateTimeBase.parseNonNegativeInt(string, n3, n);
                    bl2 = true;
                    n3 = n + 1;
                }
                if ((n = string.indexOf(83, n3)) > n3) {
                    duration.second = DateTimeBase.parseNonNegativeDouble(string, n3, n);
                    bl2 = true;
                    n3 = n + 1;
                }
            }
            if (!bl2) {
                throw new DateTimeException("duration syntax", string);
            }
        }
        if (n3 != n2 || !bl && !bl2) {
            throw new DateTimeException("duration syntax", string);
        }
        duration.normalize();
        return duration;
    }

    public Duration() {
    }

    public Duration(int n, int n2, int n3, int n4, int n5, double d) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDay(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(d);
        this.normalize();
    }

    public Duration(int n, double d) {
        this.negative = n < 0 || d < 0.0;
        this.year = 0;
        this.month = Math.abs(n);
        this.day = 0;
        this.hour = 0;
        this.minute = 0;
        this.second = Math.abs(d);
        this.normalize();
    }

    public void setNegative(boolean bl) {
        this.negative = bl;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setYear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative year component");
        }
        this.year = n;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative month component");
        }
        this.month = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative day component");
        }
        this.day = n;
    }

    public int getDay() {
        return this.day;
    }

    public void setHour(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative hour component");
        }
        this.hour = n;
    }

    public int getHour() {
        return this.hour;
    }

    public void setMinute(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative minute component");
        }
        this.minute = n;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setSecond(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("negative second component");
        }
        this.second = d;
    }

    public double getSecond() {
        return this.second;
    }

    public String toString() {
        if (this.year == 0 && this.month == 0 && this.day == 0 && this.hour == 0 && this.minute == 0 && this.second == 0.0) {
            return "PT0S";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.year > 0) {
            stringBuffer.append(this.year);
            stringBuffer.append('Y');
        }
        if (this.month > 0) {
            stringBuffer.append(this.month);
            stringBuffer.append('M');
        }
        if (this.day > 0) {
            stringBuffer.append(this.day);
            stringBuffer.append('D');
        }
        if (this.hour > 0 || this.minute > 0 || this.second > 0.0) {
            stringBuffer.append('T');
            if (this.hour > 0) {
                stringBuffer.append(this.hour);
                stringBuffer.append('H');
            }
            if (this.minute > 0) {
                stringBuffer.append(this.minute);
                stringBuffer.append('M');
            }
            if (this.second > 0.0) {
                stringBuffer.append(DateTimeBase.SECOND_FORMAT.format(this.second));
                stringBuffer.append('S');
            }
        }
        return stringBuffer.toString();
    }

    public boolean checkAsTimezone() {
        return this.getYear() == 0 && this.getMonth() == 0 && this.getDay() == 0 && this.getSecond() == 0.0 && this.getHour() >= -14 && this.getHour() <= 14;
    }

    public int getMonths() {
        return (this.year * 12 + this.month) * (this.negative ? -1 : 1);
    }

    public double getSeconds() {
        return ((double)(this.day * 24) * 3600.0 + (double)(this.hour * 3600) + (double)(this.minute * 60) + this.second) * (double)(this.negative ? -1 : 1);
    }

    public void normalize() {
        int n = (int)(this.second / 60.0);
        this.second -= (double)(60 * n);
        this.minute += n;
        n = this.minute / 60;
        this.minute -= 60 * n;
        this.hour += n;
        n = this.hour / 24;
        this.hour -= 24 * n;
        this.day += n;
        n = this.month / 12;
        this.month -= 12 * n;
        this.year += n;
    }

    public int hashCode() {
        long l = Double.doubleToRawLongBits(this.getSeconds() + (double)(this.getMonths() * 365 * 86400));
        return (int)(l >>> 32 ^ l);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)object;
        return this.getSeconds() == duration.getSeconds() && this.getMonths() == duration.getMonths();
    }

    public int compareTo(Duration duration) {
        int n = this.getMonths() - duration.getMonths();
        if (n != 0) {
            return Util.comparison(n);
        }
        return Util.comparison(this.getSeconds() - duration.getSeconds());
    }
}

