/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

public class HTable {
    static final double LOAD_FACTOR = 1.0;
    protected Key[] hash;
    protected int count = 0;
    protected int maxCount;

    public HTable(int n) {
        this.hash = new Key[n];
        this.maxCount = (int)(1.0 * (double)this.hash.length);
    }

    public HTable() {
        this(3);
    }

    public int getSize() {
        return this.count;
    }

    public Key get(Key key) {
        int n = (key.hashCode() & Integer.MAX_VALUE) % this.hash.length;
        Key key2 = this.hash[n];
        while (key2 != null) {
            if (key2.equals(key)) {
                return key2;
            }
            key2 = key2.next;
        }
        return null;
    }

    public Key put(Key key) {
        int n = (key.hashCode() & Integer.MAX_VALUE) % this.hash.length;
        Key key2 = this.hash[n];
        while (key2 != null) {
            if (key2.equals(key)) {
                return key2;
            }
            key2 = key2.next;
        }
        if (++this.count > this.maxCount) {
            this.resize();
            n = (key.hashCode() & Integer.MAX_VALUE) % this.hash.length;
        }
        Key key3 = key.duplicate();
        key3.next = this.hash[n];
        this.hash[n] = key3;
        return key3;
    }

    public void directPut(Key key) {
        if (++this.count > this.maxCount) {
            this.resize();
        }
        int n = (key.hashCode() & Integer.MAX_VALUE) % this.hash.length;
        key.next = this.hash[n];
        this.hash[n] = key;
    }

    public Key[] getKeys(Key[] keyArray) {
        int n = 0;
        int n2 = this.hash.length;
        while (--n2 >= 0) {
            Key key = this.hash[n2];
            while (key != null) {
                keyArray[n++] = key;
                key = key.next;
            }
        }
        return keyArray;
    }

    void resize() {
        Key key;
        int n;
        Key[] keyArray = this.hash;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.hash.length) {
            if (this.hash[n3] == null) {
                ++n2;
            }
            ++n3;
        }
        if (keyArray.length - n2 < this.count / 4) {
            n = 0;
            int n4 = 3;
            while (n < this.hash.length) {
                if (this.hash[n] != null) {
                    System.err.print(n + " : ");
                    key = this.hash[n];
                    while (key != null) {
                        System.err.print(" " + key);
                        key = key.next;
                    }
                    System.err.println();
                    if (--n4 <= 0) break;
                }
                ++n;
            }
        }
        this.hash = new Key[keyArray.length * 2 + 1];
        n = keyArray.length;
        while (--n >= 0) {
            Key key2 = keyArray[n];
            while (key2 != null) {
                key = key2;
                key2 = key2.next;
                int n5 = (key.hashCode() & Integer.MAX_VALUE) % this.hash.length;
                key.next = this.hash[n5];
                this.hash[n5] = key;
            }
        }
        this.maxCount = (int)(1.0 * (double)this.hash.length);
    }

    public static abstract class Key {
        public Key next;

        public abstract Key duplicate();
    }
}

