/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;

public final class FileUtil {
    private static String platformDefaultEncoding = new OutputStreamWriter(System.out).getEncoding();

    public static File urlToFile(URL uRL) {
        if (!uRL.getProtocol().equals("file")) {
            return null;
        }
        String string = uRL.getPath();
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return new File(string);
    }

    public static File urlToFile(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL == null ? null : FileUtil.urlToFile(uRL);
    }

    public static String urlToFileName(URL uRL) {
        File file = FileUtil.urlToFile(uRL);
        return file == null ? null : file.getPath();
    }

    public static String urlToFileName(String string) {
        File file = FileUtil.urlToFile(string);
        return file == null ? null : file.getPath();
    }

    public static URL fileToURL(File file) {
        URL uRL;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = file.getAbsoluteFile();
        }
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL;
    }

    public static URL fileToURL(String string) {
        return FileUtil.fileToURL(new File(string));
    }

    public static String fileToURLName(File file) {
        URL uRL = FileUtil.fileToURL(file);
        return uRL == null ? null : uRL.toExternalForm();
    }

    public static String fileToURLName(String string) {
        URL uRL = FileUtil.fileToURL(string);
        return uRL == null ? null : uRL.toExternalForm();
    }

    public static String fileDirName(String string) {
        String string2;
        char c = File.separatorChar;
        int n = string.lastIndexOf(c);
        if (n < 0 && c == '\\') {
            c = '/';
            n = string.lastIndexOf(c);
        }
        if (n < 0) {
            string2 = ".";
        } else if (n == 0) {
            string2 = File.separator;
        } else {
            string2 = string.substring(0, n);
            if (c != File.separatorChar) {
                string2 = string2.replace(c, File.separatorChar);
            }
        }
        return string2;
    }

    public static String fileBaseName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        if (n < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String fileExtension(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= n || n2 == string.length() - 1) {
            return "";
        }
        return string.substring(n2 + 1);
    }

    public static String trimFileExtension(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0 && File.separatorChar == '\\') {
            n = string.lastIndexOf(47);
        }
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf(46);
        if (n2 <= n) {
            return string;
        }
        return string.substring(0, n2);
    }

    public static boolean removeFile(String string) {
        return FileUtil.removeFile(string, false);
    }

    public static boolean removeFile(String string, boolean bl) {
        return FileUtil.removeFile(new File(string), bl);
    }

    public static boolean removeFile(File file, boolean bl) {
        if (file.isDirectory() && bl) {
            FileUtil.emptyDirectory(file);
        }
        return file.delete();
    }

    public static void emptyDirectory(String string) {
        FileUtil.emptyDirectory(new File(string));
    }

    public static void emptyDirectory(File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file, stringArray[n]);
                if (file2.isDirectory()) {
                    FileUtil.removeFile(file2, true);
                } else {
                    file2.delete();
                }
                ++n;
            }
        }
    }

    public static void copyFile(String string, String string2) throws IOException {
        FileUtil.copyFile(new File(string), new File(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            FileUtil.doCopyFile(file, fileOutputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File file, OutputStream outputStream) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[8192];
        try {
            int n;
            while ((n = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    public static String loadString(String string) throws IOException {
        return FileUtil.loadString(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        try {
            string = FileUtil.loadString(fileInputStream, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return string;
    }

    public static String loadString(URL uRL) throws IOException {
        return FileUtil.loadString(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(URL uRL, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(bl);
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        String string = null;
        String string2 = uRLConnection.getContentType();
        if (string2 != null) {
            string = FileUtil.contentTypeToCharsetName(string2);
        }
        InputStream inputStream = uRLConnection.getInputStream();
        String string3 = null;
        try {
            string3 = FileUtil.loadString(inputStream, string);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string3;
    }

    public static String contentTypeToCharsetName(String string) {
        int n;
        string = string.toLowerCase();
        String string2 = null;
        int n2 = string.indexOf("charset=");
        if (n2 >= 0 && n2 + 8 < string.length() - 1 && (n = (string2 = string.substring(n2 + 8).trim()).length()) >= 2 && string2.charAt(0) == '\"') {
            string2 = string2.substring(1, n - 1);
        }
        return string2;
    }

    public static String loadString(InputStream inputStream, String string) throws IOException {
        int n;
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static void saveString(String string, String string2) throws IOException {
        FileUtil.saveString(string, new File(string2));
    }

    public static void saveString(String string, File file) throws IOException {
        FileUtil.saveString(string, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveString(String string, File file, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            FileUtil.saveString(string, fileOutputStream, string2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    private static void saveString(String string, OutputStream outputStream, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = string2 == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string2);
        outputStreamWriter.write(string, 0, string.length());
        outputStreamWriter.flush();
    }

    public static byte[] loadBytes(String string) throws IOException {
        return FileUtil.loadBytes(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(fileInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return byArray;
    }

    public static byte[] loadBytes(URL uRL) throws IOException {
        return FileUtil.loadBytes(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(URL uRL, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(bl);
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        byte[] byArray = null;
        try {
            byArray = FileUtil.loadBytes(inputStream);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray;
    }

    private static byte[] loadBytes(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static boolean isGzipped(String string) throws IOException {
        return FileUtil.isGzipped(new File(string));
    }

    public static boolean isGzipped(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = ((InputStream)fileInputStream).read();
        int n2 = ((InputStream)fileInputStream).read();
        ((InputStream)fileInputStream).close();
        return n == 31 && n2 == 139;
    }

    public static String loadGzippedString(String string) throws IOException {
        return FileUtil.loadGzippedString(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = null;
        try {
            string = FileUtil.loadGzippedString(fileInputStream, null);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        return string;
    }

    public static String loadGzippedString(URL uRL) throws IOException {
        return FileUtil.loadGzippedString(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGzippedString(URL uRL, boolean bl) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setAllowUserInteraction(bl);
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        String string = null;
        try {
            string = FileUtil.loadGzippedString(inputStream, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string;
    }

    private static String loadGzippedString(InputStream inputStream, String string) throws IOException {
        int n;
        if (string == null) {
            string = FileUtil.defaultEncoding();
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new GZIPInputStream(inputStream), string);
        char[] cArray = new char[8192];
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        while ((n = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) != -1) {
            if (n <= 0) continue;
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static String defaultEncoding() {
        return platformDefaultEncoding;
    }
}

