/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.text.CollationElementIterator;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import net.xfra.qizxopen.util.Util;

public class Collations {
    public static final String CODEPOINT = "http://www.w3.org/2003/05/xpath-functions/collation/codepoint";
    public static final String CODEPOINT_SHORT = "codepoint";
    static final int END = -1;

    public static Collator getInstance(String string) {
        if (string.equals(CODEPOINT) || string.equals(CODEPOINT_SHORT)) {
            return null;
        }
        int n = string.indexOf(45);
        Locale locale = n < 0 ? new Locale(string) : new Locale(string.substring(0, n), string.substring(n + 1));
        return Collator.getInstance(locale);
    }

    public static Collator getInstanceWithStrength(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(35);
        String string2 = n < 0 ? string : string.substring(0, n);
        Collator collator = Collations.getInstance(string2);
        if (string.endsWith("#primary")) {
            collator.setStrength(0);
        } else if (string.endsWith("#secondary")) {
            collator.setStrength(1);
        }
        if (string.endsWith("#tertiary")) {
            collator.setStrength(2);
        }
        return collator;
    }

    public static int compare(String string, String string2, Collator collator) {
        return Util.comparison(collator == null ? string.compareTo(string2) : collator.compare(string, string2));
    }

    private static int[] preCollate(String string, RuleBasedCollator ruleBasedCollator) {
        int[] nArray;
        int n;
        int[] nArray2 = new int[string.length()];
        int n2 = 0;
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        while ((n = collationElementIterator.next()) != -1) {
            if (n == 0) continue;
            if (n2 >= nArray2.length) {
                nArray = nArray2;
                nArray2 = new int[nArray.length * 2];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            }
            nArray2[n2++] = n;
        }
        if (n2 == nArray2.length) {
            return nArray2;
        }
        nArray = new int[n2];
        System.arraycopy(nArray2, 0, nArray, 0, n2);
        return nArray;
    }

    static boolean tailMatch(CollationElementIterator collationElementIterator, int[] nArray) {
        int n = 1;
        while (n < nArray.length) {
            int n2 = collationElementIterator.next();
            if (n2 == 0) continue;
            if (n2 == -1 || n2 != nArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static int indexOf(String string, String string2, Collator collator) {
        int n;
        if (collator == null) {
            return string.indexOf(string2);
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)collator;
        int[] nArray = Collations.preCollate(string2, ruleBasedCollator);
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        while ((n = collationElementIterator.next()) != -1) {
            if (n == 0 || n != nArray[0]) continue;
            int n2 = collationElementIterator.getOffset();
            if (Collations.tailMatch(collationElementIterator, nArray)) {
                collationElementIterator.setOffset(n2);
                collationElementIterator.previous();
                return collationElementIterator.getOffset();
            }
            collationElementIterator.setOffset(n2);
        }
        return -1;
    }

    public static boolean endsWith(String string, String string2, Collator collator) {
        int n;
        if (collator == null) {
            return string.endsWith(string2);
        }
        RuleBasedCollator ruleBasedCollator = (RuleBasedCollator)collator;
        int[] nArray = Collations.preCollate(string2, ruleBasedCollator);
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator(string);
        while ((n = collationElementIterator.next()) != -1) {
            if (n == 0 || n != nArray[0]) continue;
            int n2 = collationElementIterator.getOffset();
            if (Collations.tailMatch(collationElementIterator, nArray)) {
                return collationElementIterator.next() < 0;
            }
            collationElementIterator.setOffset(n2);
        }
        return false;
    }
}

