/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.ext;

import net.xfra.qizxopen.dm.FulltextQuery;
import net.xfra.qizxopen.util.DefaultWordExtractor;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.WordExtractor;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;

public class QizxFulltext
extends Function {
    static QName qfname = QName.get(XQueryProcessor.EXTENSIONS_NS, "fulltext");
    static Prototype[] protos = new Prototype[]{new Prototype(qfname, Type.BOOLEAN.opt, class$net$xfra$qizxopen$ext$QizxFulltext$Exec == null ? (class$net$xfra$qizxopen$ext$QizxFulltext$Exec = QizxFulltext.class$("net.xfra.qizxopen.ext.QizxFulltext$Exec")) : class$net$xfra$qizxopen$ext$QizxFulltext$Exec).arg("query", (Type)Type.STRING).arg("context", (Type)Type.NODE.star), new Prototype(qfname, Type.BOOLEAN.opt, class$net$xfra$qizxopen$ext$QizxFulltext$Exec == null ? (class$net$xfra$qizxopen$ext$QizxFulltext$Exec = QizxFulltext.class$("net.xfra.qizxopen.ext.QizxFulltext$Exec")) : class$net$xfra$qizxopen$ext$QizxFulltext$Exec).arg("query", (Type)Type.STRING)};
    static /* synthetic */ Class class$net$xfra$qizxopen$ext$QizxFulltext$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    static WordExtractor getWordExtractor(EvalContext evalContext) {
        WordExtractor wordExtractor = (WordExtractor)evalContext.getProperty("word-extractor");
        return wordExtractor != null ? wordExtractor : new DefaultWordExtractor();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.BoolCall {
        FulltextQuery previousCompiled;
        String previousQuery;
        EvalContext previousContext;

        public synchronized FulltextQuery preparedQuery(Focus focus, EvalContext evalContext) throws XQueryException {
            String string = this.args[0].evalAsString(focus, evalContext);
            if (evalContext == this.previousContext && string.equals(this.previousQuery)) {
                return this.previousCompiled;
            }
            try {
                this.previousCompiled = FulltextQuery.parseQuery(string, QizxFulltext.getWordExtractor(evalContext));
                this.previousQuery = string;
                this.previousContext = evalContext;
                return this.previousCompiled;
            }
            catch (FulltextQuery.ParseException parseException) {
                evalContext.error(this.args[0], "full-text query error: " + parseException.getMessage());
                return null;
            }
        }

        public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
            FulltextQuery fulltextQuery = this.preparedQuery(focus, evalContext);
            if (this.args.length > 1) {
                Value value = this.args[1].eval(focus, evalContext);
                while (value.next()) {
                    Node node = value.asNode();
                    if (!fulltextQuery.matches(node)) continue;
                    return true;
                }
                return false;
            }
            this.checkFocus(focus, evalContext);
            return fulltextQuery.matches(focus.getItem().asNode());
        }
    }
}

