/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiverBase;
import net.xfra.qizxopen.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class SAXEventReceiver
extends XMLEventReceiverBase
implements Attributes {
    public boolean nsPrefixes = true;
    ContentHandler contentHandler;
    LexicalHandler lexicalHandler;
    ErrorHandler errorHandler;
    protected char[] charBuf;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void convertSaxException(SAXException sAXException) throws DataModelException {
        throw new DataModelException("SAX exception: " + sAXException.getMessage());
    }

    public void namespace(String string, String string2) throws DataModelException {
        super.namespace(string, string2);
        try {
            if (this.contentHandler != null) {
                this.contentHandler.startPrefixMapping(string, string2);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void startDocument() throws DataModelException {
        super.startDocument();
        try {
            if (this.contentHandler != null) {
                this.contentHandler.startDocument();
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void endDocument() throws DataModelException {
        try {
            if (this.contentHandler != null) {
                this.contentHandler.endDocument();
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
        super.endDocument();
    }

    public void flushElement(boolean bl) throws DataModelException {
        if (!this.elementStarted) {
            return;
        }
        this.elementStarted = false;
        try {
            String string;
            String string2 = string = this.nsPrefixes ? this.prefixes.prefixedName(this.tagName) : null;
            if (this.contentHandler != null) {
                this.contentHandler.startElement(this.tagName.getURI(), this.tagName.getLocalName(), string, this);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void endElement(QName qName) throws DataModelException {
        if (this.elementStarted) {
            this.flushElement(true);
        }
        if (this.contentHandler != null) {
            try {
                String string = this.nsPrefixes ? this.prefixes.prefixedName(this.tagName) : null;
                this.contentHandler.endElement(this.tagName.getURI(), this.tagName.getLocalName(), string);
                int n = 1;
                while (n <= this.nsCnt) {
                    this.contentHandler.endPrefixMapping(this.prefixes.getLastPrefix(n));
                    ++n;
                }
            }
            catch (SAXException sAXException) {
                this.convertSaxException(sAXException);
            }
        }
        super.endElement(qName);
    }

    public void text(String string) throws DataModelException {
        try {
            if (this.elementStarted) {
                this.flushElement(false);
            }
            int n = string.length();
            if (this.charBuf == null || n > this.charBuf.length) {
                this.charBuf = new char[n];
            }
            string.getChars(0, n, this.charBuf, 0);
            if (this.contentHandler != null) {
                this.contentHandler.characters(this.charBuf, 0, n);
            }
            this.spaceNeeded = false;
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void atom(String string) throws DataModelException {
        try {
            if (this.elementStarted) {
                this.flushElement(false);
            }
            if (this.spaceNeeded && this.contentHandler != null) {
                this.contentHandler.characters(XMLEventReceiverBase.blank, 0, 1);
            }
            int n = string.length();
            if (this.charBuf == null || n > this.charBuf.length) {
                this.charBuf = new char[n];
            }
            string.getChars(0, n, this.charBuf, 0);
            if (this.contentHandler != null) {
                this.contentHandler.characters(this.charBuf, 0, n);
            }
            this.spaceNeeded = true;
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void pi(String string, String string2) throws DataModelException {
        try {
            if (this.elementStarted) {
                this.flushElement(false);
            }
            if (this.contentHandler != null) {
                this.contentHandler.processingInstruction(string, string2);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public void comment(String string) throws DataModelException {
        try {
            if (this.elementStarted) {
                this.flushElement(false);
            }
            int n = string.length();
            if (this.charBuf == null || n > this.charBuf.length) {
                this.charBuf = new char[n];
            }
            string.getChars(0, n, this.charBuf, 0);
            if (this.lexicalHandler != null) {
                this.lexicalHandler.comment(this.charBuf, 0, n);
            }
        }
        catch (SAXException sAXException) {
            this.convertSaxException(sAXException);
        }
    }

    public int getIndex(QName qName) {
        int n = this.attrCnt;
        while (--n >= 0) {
            if (this.attrNames[n] != qName) continue;
            return n;
        }
        return -1;
    }

    public int getIndex(String string) {
        return this.getIndex(this.prefixes.expandName(string));
    }

    public int getIndex(String string, String string2) {
        return this.getIndex(QName.get(string, string2));
    }

    public int getLength() {
        return this.attrCnt;
    }

    public String getLocalName(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.attrNames[n].getLocalName();
    }

    public String getURI(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.attrNames[n].getURI();
    }

    public String getQName(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.prefixes.prefixedName(this.attrNames[n]);
    }

    public String getType(int n) {
        return "CDATA";
    }

    public String getType(String string) {
        return "CDATA";
    }

    public String getType(String string, String string2) {
        return "CDATA";
    }

    public String getValue(int n) {
        return n < 0 || n >= this.attrCnt ? null : this.attrValues[n];
    }

    public String getValue(String string) {
        return this.getValue(this.getIndex(string));
    }

    public String getValue(String string, String string2) {
        return this.getValue(this.getIndex(string, string2));
    }
}

