/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;

public class BaseNodeTest
implements NodeTest {
    public int kind;
    public Namespace namespace;
    public String name;
    public QName qname;

    public BaseNodeTest(int n, Namespace namespace, String string) {
        this.kind = n;
        this.namespace = namespace;
        if (string != null) {
            string = string.intern();
        }
        this.name = string;
        if (namespace != null && string != null) {
            this.qname = QName.get(namespace, string);
        }
    }

    public String toString() {
        return "nodeTest(" + this.kind + ", " + this.namespace + ":" + this.name + ")";
    }

    public int getNodeKind() {
        return this.kind;
    }

    public boolean staticallyCheckable() {
        return this.namespace == null && this.name == null;
    }

    public boolean accepts(int n, QName qName) {
        if (this.kind > 0 && this.kind != n) {
            return false;
        }
        if (qName == null) {
            return true;
        }
        if (this.namespace == null && this.name == null) {
            return true;
        }
        if (this.qname != null) {
            return this.qname == qName;
        }
        if (this.namespace != null) {
            return this.namespace == qName.getNamespace();
        }
        return this.name == qName.getLocalName();
    }

    public boolean needsNode() {
        return false;
    }

    public boolean accepts(Node node) {
        return this.accepts(node.getNature(), node.getNodeName());
    }
}

