/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.DateUtils;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.Request;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest
implements Request {
    private Logger log = LoggerFactory.getLogger(AbstractRequest.class);
    public static final int INFINITY = 3;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public abstract String getRequestHeader(Request.Header var1);

    @Override
    public Date getIfModifiedHeader() {
        String s = this.getRequestHeader(Request.Header.IF_MODIFIED);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return DateUtils.parseDate(s);
        }
        catch (DateUtils.DateParseException ex) {
            this.log.error("Unable to parse date: " + s, (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getExpectHeader() {
        return this.getRequestHeader(Request.Header.EXPECT);
    }

    @Override
    public String getAcceptHeader() {
        return this.getRequestHeader(Request.Header.ACCEPT);
    }

    @Override
    public String getRefererHeader() {
        return this.getRequestHeader(Request.Header.REFERER);
    }

    @Override
    public String getContentTypeHeader() {
        return this.getRequestHeader(Request.Header.CONTENT_TYPE);
    }

    @Override
    public String getAcceptEncodingHeader() {
        return this.getRequestHeader(Request.Header.ACCEPT_ENCODING);
    }

    @Override
    public String getUserAgentHeader() {
        return this.getRequestHeader(Request.Header.USER_AGENT);
    }

    @Override
    public int getDepthHeader() {
        String depthStr = this.getRequestHeader(Request.Header.DEPTH);
        if (depthStr == null) {
            return 3;
        }
        if (depthStr.equals("0")) {
            return 0;
        }
        if (depthStr.equals("1")) {
            return 1;
        }
        if (depthStr.equals("infinity")) {
            return 3;
        }
        this.log.warn("Unknown depth value: " + depthStr);
        return 3;
    }

    @Override
    public String getHostHeader() {
        return this.getRequestHeader(Request.Header.HOST);
    }

    @Override
    public String getDestinationHeader() {
        return this.getRequestHeader(Request.Header.DESTINATION);
    }

    @Override
    public Long getContentLengthHeader() {
        String s = this.getRequestHeader(Request.Header.CONTENT_LENGTH);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            long l = Long.parseLong(s);
            return l;
        }
        catch (NumberFormatException ex) {
            this.log.warn("Couldnt parse content length header: " + s);
            return null;
        }
    }

    @Override
    public String getTimeoutHeader() {
        return this.getRequestHeader(Request.Header.TIMEOUT);
    }

    @Override
    public String getIfHeader() {
        return this.getRequestHeader(Request.Header.IF);
    }

    @Override
    public String getLockTokenHeader() {
        return this.getRequestHeader(Request.Header.LOCK_TOKEN);
    }

    @Override
    public String getRangeHeader() {
        return this.getRequestHeader(Request.Header.RANGE);
    }

    @Override
    public String getContentRangeHeader() {
        return this.getRequestHeader(Request.Header.CONTENT_RANGE);
    }

    @Override
    public Boolean getOverwriteHeader() {
        String s = this.getRequestHeader(Request.Header.OVERWRITE);
        if (s == null || s.length() == 0) {
            return null;
        }
        return "T".equals(s);
    }

    @Override
    public String getIfMatchHeader() {
        return this.getRequestHeader(Request.Header.IF_MATCH);
    }

    @Override
    public String getIfNoneMatchHeader() {
        return this.getRequestHeader(Request.Header.IF_NONE_MATCH);
    }

    @Override
    public String getAbsolutePath() {
        return AbstractRequest.stripToPath(this.getAbsoluteUrl());
    }

    public static String stripToPath(String url) {
        int i = url.indexOf("/", 8);
        if (i > 0) {
            url = url.substring(i);
        }
        if ((i = url.indexOf("?")) > 0) {
            url = url.substring(0, i);
        }
        return url;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public Map<String, String> getParams() {
        return (Map)this.attributes.get("_params");
    }

    @Override
    public Map<String, FileItem> getFiles() {
        return (Map)this.attributes.get("_files");
    }
}

