/*
 * Decompiled with CFR 0.152.
 */
package net.reduls.igo.dictionary.build;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.reduls.igo.trie.Builder;
import net.reduls.igo.trie.Searcher;
import net.reduls.igo.util.FileMappedOutputStream;
import net.reduls.igo.util.ReadLine;

public final class WordDic {
    private final String encoding;
    private final String inputDir;
    private final String outputDir;
    private final String delim;

    public WordDic(String string, String string2, String string3, String string4) {
        this.inputDir = string;
        this.encoding = string2;
        this.outputDir = string3;
        this.delim = string4;
    }

    public void buildWordIdMap() throws ParseException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.collectKey(this.inputDir + "/unk.def", arrayList, "\u0002");
        for (File file : new File(this.inputDir).listFiles(new onlyCsv())) {
            this.collectKey(file.getPath(), arrayList, "");
        }
        Builder builder = Builder.build(arrayList);
        builder.save(this.outputDir + "/word2id");
    }

    private void collectKey(String string, List<String> list, String string2) throws IOException, ParseException {
        ReadLine readLine = new ReadLine(string, this.encoding);
        try {
            String string3 = readLine.read();
            while (string3 != null) {
                String string4 = string3.substring(0, string3.indexOf(this.delim, 1));
                list.add(string2 + string4);
                string3 = readLine.read();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw WordDic.parseException("Word surface must be terminated with '" + this.delim + "'.", string, readLine);
        }
        finally {
            readLine.close();
        }
    }

    private static ParseException parseException(String string, String string2, ReadLine readLine) {
        return new ParseException(string + "\t{file: " + string2 + ", line: " + readLine.lineNumber() + "}", readLine.lineNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildWordInfo() throws ParseException, IOException {
        Searcher searcher = new Searcher(this.outputDir + "/word2id");
        ArrayList<ArrayList<WordInfo>> arrayList = new ArrayList<ArrayList<WordInfo>>(searcher.size());
        for (int i = 0; i < searcher.size(); ++i) {
            arrayList.add(new ArrayList());
        }
        this.collectWordInfo(this.inputDir + "/unk.def", searcher, "\u0002", arrayList);
        for (File object22 : new File(this.inputDir).listFiles(new onlyCsv())) {
            this.collectWordInfo(object22.getPath(), searcher, "", arrayList);
        }
        WordDic.removeUnusedEntry(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (ArrayList<WordInfo> arrayList2 : arrayList) {
            n += arrayList2.size();
        }
        FileMappedOutputStream fileMappedOutputStream = new FileMappedOutputStream(this.outputDir + "/word.inf", (n + 1) * 10);
        try {
            for (ArrayList<WordInfo> arrayList3 : arrayList) {
                for (Object object : arrayList3) {
                    fileMappedOutputStream.putInt(stringBuilder.length());
                    stringBuilder.append(((WordInfo)object).data);
                }
            }
            fileMappedOutputStream.putInt(stringBuilder.length());
            for (ArrayList<WordInfo> arrayList4 : arrayList) {
                for (Object object : arrayList4) {
                    fileMappedOutputStream.putShort(((WordInfo)object).leftId);
                }
            }
            fileMappedOutputStream.putShort((short)0);
            for (ArrayList<WordInfo> arrayList5 : arrayList) {
                for (Object object : arrayList5) {
                    fileMappedOutputStream.putShort(((WordInfo)object).rightId);
                }
            }
            fileMappedOutputStream.putShort((short)0);
            for (ArrayList<WordInfo> arrayList6 : arrayList) {
                for (Object object : arrayList6) {
                    fileMappedOutputStream.putShort(((WordInfo)object).cost);
                }
            }
            fileMappedOutputStream.putShort((short)0);
        }
        finally {
            fileMappedOutputStream.close();
        }
        FileMappedOutputStream fileMappedOutputStream2 = new FileMappedOutputStream(this.outputDir + "/word.dat", stringBuilder.length() * 2);
        try {
            fileMappedOutputStream2.putString(stringBuilder.toString());
        }
        finally {
            fileMappedOutputStream2.close();
        }
        FileMappedOutputStream fileMappedOutputStream3 = new FileMappedOutputStream(this.outputDir + "/word.ary.idx", (arrayList.size() + 1) * 4);
        int n2 = 0;
        try {
            for (ArrayList arrayList7 : arrayList) {
                fileMappedOutputStream3.putInt(n2);
                n2 += arrayList7.size();
            }
            fileMappedOutputStream3.putInt(n2);
        }
        finally {
            fileMappedOutputStream3.close();
        }
    }

    private void collectWordInfo(String string, Searcher searcher, String string2, ArrayList<ArrayList<WordInfo>> arrayList) throws ParseException, IOException {
        ReadLine readLine = new ReadLine(string, this.encoding);
        try {
            String string3 = readLine.read();
            while (string3 != null) {
                int n = string3.indexOf(this.delim, 1);
                int n2 = string3.indexOf(this.delim, n + 1);
                int n3 = string3.indexOf(this.delim, n2 + 1);
                int n4 = string3.indexOf(this.delim, n3 + 1);
                if (n == -1) {
                    throw WordDic.parseException("Word surface must be terminated with '" + this.delim + "'.", string, readLine);
                }
                if (n2 == -1) {
                    throw WordDic.parseException("Word left context id must be terminated with '" + this.delim + "'.", string, readLine);
                }
                if (n3 == -1) {
                    throw WordDic.parseException("Word right context id must be terminated with '" + this.delim + "'.", string, readLine);
                }
                if (n4 == -1) {
                    throw WordDic.parseException("Word cost must be terminated with '" + this.delim + "'.", string, readLine);
                }
                String string4 = string3.substring(n4 + 1);
                int n5 = searcher.search(string2 + string3.substring(0, n));
                if (n5 < 0) {
                    throw WordDic.parseException("Word '" + string3.substring(0, n) + "' is unregistered in trie", string, readLine);
                }
                arrayList.get(n5).add(new WordInfo(Short.valueOf(string3.substring(n + 1, n2)), Short.valueOf(string3.substring(n2 + 1, n3)), Short.valueOf(string3.substring(n3 + 1, n4)), string4));
                string3 = readLine.read();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw WordDic.parseException("Parse short integer failed. " + numberFormatException.getMessage(), string, readLine);
        }
        finally {
            readLine.close();
        }
    }

    private static void removeUnusedEntry(ArrayList<ArrayList<WordInfo>> arrayList) {
        for (ArrayList<WordInfo> arrayList2 : arrayList) {
            int n;
            Collections.sort(arrayList2);
            int n2 = 0;
            for (n = 1; n < arrayList2.size(); ++n) {
                if (arrayList2.get((int)n2).leftId == arrayList2.get((int)n).leftId && arrayList2.get((int)n2).rightId == arrayList2.get((int)n).rightId) continue;
                arrayList2.set(++n2, arrayList2.get(n));
            }
            for (n = arrayList2.size() - 1; n > n2; --n) {
                arrayList2.remove(n);
            }
        }
    }

    private static class onlyCsv
    implements FileFilter {
        private onlyCsv() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.toString().matches(".*\\.csv$");
        }
    }

    private static class WordInfo
    implements Comparable<WordInfo> {
        public short leftId;
        public short rightId;
        public short cost;
        public String data;

        public WordInfo(short s, short s2, short s3, String string) {
            this.leftId = s;
            this.rightId = s2;
            this.cost = s3;
            this.data = string;
        }

        @Override
        public int compareTo(WordInfo wordInfo) {
            if (this.leftId != wordInfo.leftId) {
                return this.leftId - wordInfo.leftId;
            }
            if (this.rightId != wordInfo.rightId) {
                return this.rightId - wordInfo.rightId;
            }
            return this.cost - wordInfo.cost;
        }
    }
}

