/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.util.Locale;
import org.basex.query.QueryText;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;

public interface HttpText {
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String PRAGMA = "Pragma";
    public static final String EXPIRES = "Expires";
    public static final String LOCATION = "Location";
    public static final String ACCEPT = "Accept";
    public static final String BASIC = "Basic";
    public static final String DIGEST = "Digest";
    public static final byte[] CONTENT_DISPOSITION = Token.token("Content-Disposition");
    public static final byte[] DASHES = Token.token("--");
    public static final String CHARSET = "charset";
    public static final String FILENAME = "filename";
    public static final String DEFAULT_BOUNDARY = "1BEF0A57BE110FD467A";
    public static final String BOUNDARY = "boundary";
    public static final String TRACE = "TRACE";
    public static final String DELETE = "DELETE";
    public static final String SRC = "src";
    public static final String MD5 = "MD5";
    public static final String MD5_SESS = "MD5-sess";
    public static final String AUTH = "auth";
    public static final String AUTH_INT = "auth-int";
    public static final String GZIP = "gzip";
    public static final QNm Q_BODY = new QNm(QueryText.HTTP_PREFIX, "body", QueryText.HTTP_URI);
    public static final QNm Q_RESPONSE = new QNm(QueryText.HTTP_PREFIX, "response", QueryText.HTTP_URI);
    public static final QNm Q_HEADER = new QNm(QueryText.HTTP_PREFIX, "header", QueryText.HTTP_URI);
    public static final QNm Q_MULTIPART = new QNm(QueryText.HTTP_PREFIX, "multipart", QueryText.HTTP_URI);
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final byte[] STATUS = Token.token("status");
    public static final byte[] MESSAGE = Token.token("message");
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String BINARY = "binary";
    public static final String BASE64 = "base64";

    public static enum Request {
        NC,
        QOP,
        URI,
        HREF,
        NONCE,
        REALM,
        OPAQUE,
        CNONCE,
        METHOD,
        TIMEOUT,
        RESPONSE,
        PASSWORD,
        USERNAME,
        ALGORITHM,
        AUTH_METHOD,
        STATUS_ONLY,
        FOLLOW_REDIRECT,
        SEND_AUTHORIZATION,
        OVERRIDE_MEDIA_TYPE;

        public static final Request[] VALUES;

        public static Request get(String key) {
            for (Request r : VALUES) {
                if (!key.equals(r.toString())) continue;
                return r;
            }
            return null;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        }

        static {
            VALUES = Request.values();
        }
    }
}

