/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Scanner;
import java.util.function.BiConsumer;
import org.basex.core.Text;
import org.basex.io.IOStream;
import org.basex.query.QueryException;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class Util {
    private static final boolean NOCONSOLE = System.console() == null;

    private Util() {
    }

    public static String bug(Throwable throwable) {
        TokenBuilder tb = new TokenBuilder("Improper use? Potential bug? Your feedback is welcome:");
        tb.add(Text.NL).add("Contact: ").add(Prop.MAILING_LIST);
        tb.add(Text.NL).add("Version: ").add(Prop.TITLE);
        tb.add(Text.NL).add("Java: ").add(System.getProperty("java.vendor"));
        tb.add(", ").add(System.getProperty("java.version"));
        tb.add(Text.NL).add("OS: ").add(System.getProperty("os.name"));
        tb.add(", ").add(System.getProperty("os.arch"));
        tb.add(Text.NL).add("Stack Trace: ");
        for (String e : Util.toArray(throwable)) {
            tb.add(Text.NL).add(e);
        }
        return tb.toString();
    }

    public static RuntimeException notExpected() {
        return Util.notExpected("Not Expected.", new Object[0]);
    }

    public static RuntimeException notExpected(Object message, Object ... ext) {
        return new RuntimeException(Util.info(message, ext));
    }

    public static String className(Object object) {
        return Util.className(object.getClass());
    }

    public static String className(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public static String input() {
        Scanner sc = new Scanner(System.in);
        return sc.hasNextLine() ? sc.nextLine().trim() : "";
    }

    public static String password() {
        if (NOCONSOLE) {
            return Util.input();
        }
        char[] pw = System.console().readPassword();
        return pw != null ? new String(pw) : "";
    }

    public static void outln() {
        Util.out(Text.NL, new Object[0]);
    }

    public static void outln(Object string, Object ... ext) {
        Util.out((string instanceof byte[] ? Token.string((byte[])string) : string) + Text.NL, ext);
    }

    public static void out(Object string, Object ... ext) {
        System.out.print(Util.info(string, ext));
    }

    public static Throwable rootException(Throwable throwable) {
        Throwable th = throwable;
        while (true) {
            Util.debug(th);
            Throwable ca = th.getCause();
            if (ca == null || th instanceof QueryException && !(ca instanceof QueryException)) {
                return th;
            }
            th = ca;
        }
    }

    public static void errln(Object object, Object ... ext) {
        Util.err((object instanceof Throwable ? Util.message((Throwable)object) : object) + Text.NL, ext);
    }

    public static void err(String string, Object ... ext) {
        System.err.print(Util.info(string, ext));
    }

    public static String message(Throwable throwable) {
        Util.debug(throwable);
        if (throwable instanceof BindException) {
            return Text.SRV_RUNNING;
        }
        if (throwable instanceof ConnectException) {
            return Text.CONNECTION_ERROR;
        }
        if (throwable instanceof SocketTimeoutException) {
            return Text.TIMEOUT_EXCEEDED;
        }
        if (throwable instanceof SocketException) {
            return Text.CONNECTION_ERROR;
        }
        String msg = throwable.getMessage();
        if (msg == null || msg.isEmpty() || throwable instanceof RuntimeException) {
            msg = throwable.toString();
        }
        if (throwable instanceof FileNotFoundException) {
            return Util.info(Text.RES_NOT_FOUND_X, msg);
        }
        if (throwable instanceof UnknownHostException) {
            return Util.info(Text.UNKNOWN_HOST_X, msg);
        }
        return msg;
    }

    public static void debug(Throwable throwable) {
        if (Prop.debug && throwable != null) {
            Util.stack(throwable);
        }
    }

    public static void debug(Object string, Object ... ext) {
        if (Prop.debug) {
            Util.errln(string, ext);
        }
    }

    public static String info(Object string, Object ... ext) {
        return Token.string(Util.inf(string, ext));
    }

    public static byte[] inf(Object string, Object ... ext) {
        return new TokenBuilder().addExt(string, ext).finish();
    }

    public static void stack(String message) {
        Util.stack(message, Short.MAX_VALUE);
    }

    public static void stack(int depth) {
        Util.stack("You're here:", depth);
    }

    private static void stack(String message, int depth) {
        Util.errln(message, new Object[0]);
        String[] stack = Util.toArray(new Throwable());
        int l = Math.min(Math.max(2, depth + 2), stack.length);
        for (int s = 2; s < l; ++s) {
            Util.errln(stack[s], new Object[0]);
        }
    }

    public static void stack(Throwable throwable) {
        throwable.printStackTrace();
    }

    private static String[] toArray(Throwable throwable) {
        StackTraceElement[] st = throwable.getStackTrace();
        int sl = st.length;
        String[] obj = new String[sl + 1];
        obj[0] = throwable.toString();
        for (int s = 0; s < sl; ++s) {
            obj[s + 1] = "\tat " + st[s];
        }
        return obj;
    }

    public static Process start(Class<?> clazz, String ... args) {
        String[] largs = new String[]{"java", "-Xmx" + Runtime.getRuntime().maxMemory(), "-cp", System.getProperty("java.class.path")};
        StringList sl = (StringList)new StringList().add(largs);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key.toString().startsWith("org.basex.")) {
                sl.add("-D" + key + '=' + value);
            }
        }));
        ((StringList)((Object)((StringList)((Object)sl.add(clazz.getName()))).add("-D"))).add(args);
        try {
            return new ProcessBuilder((String[])sl.finish()).start();
        }
        catch (IOException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }

    public static String error(Process process, int timeout) {
        int wait = 200;
        int to = Math.max(timeout / 200, 1);
        for (int c = 0; c < to; ++c) {
            try {
                int exit = process.exitValue();
                if (exit == 1) {
                    return Token.string(new IOStream(process.getErrorStream()).read());
                }
                break;
            }
            catch (IllegalThreadStateException ex) {
                Util.debug(ex);
                Performance.sleep(200L);
                continue;
            }
            catch (IOException ex) {
                return ex.getLocalizedMessage();
            }
        }
        return null;
    }
}

