/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.basex.util.Prop;
import org.basex.util.Util;

final class JarManifest {
    private static final Attributes MAP;

    private JarManifest() {
    }

    public static Object get(String key) {
        if (MAP != null) {
            for (Object k : MAP.keySet()) {
                if (!key.equals(k.toString())) continue;
                return MAP.get(k);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        Attributes map = null;
        URL location = Prop.LOCATION;
        if (location != null) {
            String jar = location.getFile();
            try {
                ClassLoader cl = JarManifest.class.getClassLoader();
                Enumeration<URL> list = cl.getResources("META-INF/MANIFEST.MF");
                while (list.hasMoreElements()) {
                    URL url = list.nextElement();
                    if (!url.getFile().contains(jar)) continue;
                    try (InputStream in = url.openStream();){
                        map = new Manifest(in).getMainAttributes();
                        break;
                    }
                }
            }
            catch (IOException ex) {
                Util.stack(ex);
            }
        }
        MAP = map;
    }
}

