/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.Num;

public final class Compress {
    public static final long COMPRESS = 0x4000000000L;
    private static final byte[] UNPACK1 = new byte[]{32, 97, 101, 110, 105, 111, 114, 115, 116, 108, 117, 104, 100, 99, 103, 109, 112, 121, 98, 107, 102, 118, 67, 83, 119, 77, 65, 66, 80, 122, 46, 10, 84, 82, 75, 76, 71, 78, 72, 106, 69, 73, 68, 70, 74, 120, 79, 113, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 45, 39, 44, 34, 63, 86, 87, 85, 90, 89, 81, 88, 9, 64, 40, 47, 41, 43, 126, 33, 35, 36, 37, 38, 42, 59, 60, 61, 62, 91, 92, 93, 94, 95, 96, 123, 124, 125, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final byte[] UNPACK2 = new byte[UNPACK1.length];
    private static final byte[] PACK1 = new byte[UNPACK1.length];
    private static final byte[] PACK2 = new byte[UNPACK1.length];

    private Compress() {
    }

    public static byte[] pack(byte[] text) {
        byte[] map;
        int length = text.length - 1;
        if (length < 4) {
            return text;
        }
        byte[] bytes = new byte[length];
        int size = Num.set(bytes, length + 1);
        int lc = 0;
        int uc = 0;
        int out = 0;
        for (byte t : text) {
            lc += t >= 65 && t <= 90 ? -1 : 1;
            uc += t >= 0 ? 1 : -1;
        }
        if (uc < 0) {
            return text;
        }
        if (lc >= 0) {
            out = 2;
            map = PACK1;
        } else {
            map = PACK2;
        }
        int off = 2;
        for (byte t : text) {
            int s;
            int in;
            byte b;
            byte by = b = t >= 0 ? map[t] : t;
            if (b >= 0 && b < 8) {
                in = 1 | b << 1;
                s = 4;
            } else if (b >= 8 && b < 16) {
                in = 2 | b << 2;
                s = 5;
            } else if (b >= 16 && b < 32) {
                in = 4 | b << 3;
                s = 7;
            } else if (b >= 32 && b < 64) {
                in = 8 | b << 4;
                s = 9;
            } else {
                in = b << 4;
                s = 12;
            }
            for (int i = 0; i < s; ++i) {
                out |= (in & 1) << off;
                in >>>= 1;
                if ((off = off + 1 & 7) != 0) continue;
                if (size == length) {
                    return text;
                }
                bytes[size++] = (byte)out;
                out = 0;
            }
        }
        if (off != 0) {
            if (size == length) {
                return text;
            }
            bytes[size++] = (byte)out;
        }
        return size < length ? Arrays.copyOf(bytes, size) : bytes;
    }

    public static byte[] unpack(byte[] text) {
        int pos = (Num.length(text, 0) << 3) + 1;
        byte[] map = Compress.isSet(text, pos++) ? UNPACK1 : UNPACK2;
        int size = Num.get(text, 0);
        byte[] bytes = new byte[size];
        for (int b = 0; b < size; ++b) {
            int bits;
            int out = 0;
            if (Compress.isSet(text, pos++)) {
                bits = 3;
            } else if (Compress.isSet(text, pos++)) {
                bits = 3;
                out = 8;
            } else if (Compress.isSet(text, pos++)) {
                bits = 4;
                out = 16;
            } else if (Compress.isSet(text, pos++)) {
                bits = 5;
                out = 32;
            } else {
                bits = 8;
            }
            int bit = 0;
            while (bit < bits) {
                if ((text[pos >>> 3] & 1 << (pos & 7)) != 0) {
                    out |= 1 << bit;
                }
                ++bit;
                ++pos;
            }
            bytes[b] = (byte)(out >= 128 ? out : map[out]);
        }
        return bytes;
    }

    public static boolean compressed(long value) {
        return (value & 0x4000000000L) != 0L;
    }

    private static boolean isSet(byte[] txt, int pos) {
        return (txt[pos >>> 3] & 1 << (pos & 7)) != 0;
    }

    static {
        int pl = UNPACK1.length;
        for (int p = 0; p < pl; ++p) {
            byte b2;
            int b1 = UNPACK1[p];
            Compress.UNPACK2[p] = b2 = (byte)(b1 >= 65 && b1 <= 90 ? b1 + 32 : (b1 >= 97 && b1 <= 122 ? b1 - 32 : b1));
            Compress.PACK1[b1] = (byte)p;
            Compress.PACK2[b2] = (byte)p;
        }
    }
}

