/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.Objects;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.path.Test;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class SeqType {
    public static final SeqType EMP = AtomType.ITEM.seqType(Occ.ZERO);
    public static final SeqType ITEM_O = AtomType.ITEM.seqType();
    public static final SeqType ITEM_ZO = AtomType.ITEM.seqType(Occ.ZERO_ONE);
    public static final SeqType ITEM_ZM = AtomType.ITEM.seqType(Occ.ZERO_MORE);
    public static final SeqType ITEM_OM = AtomType.ITEM.seqType(Occ.ONE_MORE);
    public static final SeqType AAT_O = AtomType.AAT.seqType();
    public static final SeqType AAT_ZO = AtomType.AAT.seqType(Occ.ZERO_ONE);
    public static final SeqType AAT_ZM = AtomType.AAT.seqType(Occ.ZERO_MORE);
    public static final SeqType NUM_O = AtomType.NUM.seqType();
    public static final SeqType NUM_ZO = AtomType.NUM.seqType(Occ.ZERO_ONE);
    public static final SeqType DBL_O = AtomType.DBL.seqType();
    public static final SeqType DBL_ZO = AtomType.DBL.seqType(Occ.ZERO_ONE);
    public static final SeqType DBL_ZM = AtomType.DBL.seqType(Occ.ZERO_MORE);
    public static final SeqType FLT_O = AtomType.FLT.seqType();
    public static final SeqType DEC_ZO = AtomType.DEC.seqType(Occ.ZERO_ONE);
    public static final SeqType ITR_O = AtomType.ITR.seqType();
    public static final SeqType ITR_ZO = AtomType.ITR.seqType(Occ.ZERO_ONE);
    public static final SeqType ITR_ZM = AtomType.ITR.seqType(Occ.ZERO_MORE);
    public static final SeqType BYT_ZM = AtomType.BYT.seqType(Occ.ZERO_MORE);
    public static final SeqType STR_O = AtomType.STR.seqType();
    public static final SeqType STR_ZO = AtomType.STR.seqType(Occ.ZERO_ONE);
    public static final SeqType STR_ZM = AtomType.STR.seqType(Occ.ZERO_MORE);
    public static final SeqType NCN_ZO = AtomType.NCN.seqType(Occ.ZERO_ONE);
    public static final SeqType LAN_O = AtomType.LAN.seqType();
    public static final SeqType URI_O = AtomType.URI.seqType();
    public static final SeqType URI_ZO = AtomType.URI.seqType(Occ.ZERO_ONE);
    public static final SeqType URI_ZM = AtomType.URI.seqType(Occ.ZERO_MORE);
    public static final SeqType QNM_O = AtomType.QNM.seqType();
    public static final SeqType QNM_ZO = AtomType.QNM.seqType(Occ.ZERO_ONE);
    public static final SeqType BLN_O = AtomType.BLN.seqType();
    public static final SeqType BLN_ZO = AtomType.BLN.seqType(Occ.ZERO_ONE);
    public static final SeqType DAT_O = AtomType.DAT.seqType();
    public static final SeqType DAT_ZO = AtomType.DAT.seqType(Occ.ZERO_ONE);
    public static final SeqType DTD_O = AtomType.DTD.seqType();
    public static final SeqType DTD_ZO = AtomType.DTD.seqType(Occ.ZERO_ONE);
    public static final SeqType DTM_O = AtomType.DTM.seqType();
    public static final SeqType DTM_ZO = AtomType.DTM.seqType(Occ.ZERO_ONE);
    public static final SeqType TIM_O = AtomType.TIM.seqType();
    public static final SeqType TIM_ZO = AtomType.TIM.seqType(Occ.ZERO_ONE);
    public static final SeqType DUR_ZO = AtomType.DUR.seqType(Occ.ZERO_ONE);
    public static final SeqType BIN_O = AtomType.BIN.seqType();
    public static final SeqType HEX_O = AtomType.HEX.seqType();
    public static final SeqType B64_O = AtomType.B64.seqType();
    public static final SeqType B64_ZO = AtomType.B64.seqType(Occ.ZERO_ONE);
    public static final SeqType B64_ZM = AtomType.B64.seqType(Occ.ZERO_MORE);
    public static final SeqType NOD_O = NodeType.NOD.seqType();
    public static final SeqType NOD_ZO = NodeType.NOD.seqType(Occ.ZERO_ONE);
    public static final SeqType NOD_ZM = NodeType.NOD.seqType(Occ.ZERO_MORE);
    public static final SeqType ATT_O = NodeType.ATT.seqType();
    public static final SeqType ATT_ZM = NodeType.ATT.seqType(Occ.ZERO_MORE);
    public static final SeqType COM_O = NodeType.COM.seqType();
    public static final SeqType DOC_O = NodeType.DOC.seqType();
    public static final SeqType DOC_ZO = NodeType.DOC.seqType(Occ.ZERO_ONE);
    public static final SeqType DOC_ZM = NodeType.DOC.seqType(Occ.ZERO_MORE);
    public static final SeqType ELM_O = NodeType.ELM.seqType();
    public static final SeqType ELM_ZM = NodeType.ELM.seqType(Occ.ZERO_MORE);
    public static final SeqType NSP_O = NodeType.NSP.seqType();
    public static final SeqType PI_O = NodeType.PI.seqType();
    public static final SeqType TXT_ZO = NodeType.TXT.seqType(Occ.ZERO_ONE);
    public static final SeqType TXT_ZM = NodeType.TXT.seqType(Occ.ZERO_MORE);
    public static final FuncType ANY_FUNC = new FuncType(null, (SeqType[])null);
    public static final MapType ANY_MAP = new MapType(AtomType.AAT, ITEM_ZM);
    public static final ArrayType ANY_ARRAY = new ArrayType(ITEM_ZM);
    public static final SeqType FUNC_O = ANY_FUNC.seqType();
    public static final SeqType FUNC_ZO = ANY_FUNC.seqType(Occ.ZERO_ONE);
    public static final SeqType FUNC_ZM = ANY_FUNC.seqType(Occ.ZERO_MORE);
    public static final SeqType MAP_O = ANY_MAP.seqType();
    public static final SeqType MAP_ZO = ANY_MAP.seqType(Occ.ZERO_ONE);
    public static final SeqType MAP_ZM = ANY_MAP.seqType(Occ.ZERO_MORE);
    public static final SeqType ARRAY_O = ANY_ARRAY.seqType();
    public static final SeqType ARRAY_ZM = ANY_ARRAY.seqType(Occ.ZERO_MORE);
    public final Type type;
    public final Occ occ;
    private final Test kind;

    SeqType(Type type, Occ occ) {
        this(type, occ, null);
    }

    private SeqType(Type type, Occ occ, Test kind) {
        this.type = type;
        this.occ = occ;
        this.kind = kind;
    }

    public static SeqType get(Type type, Occ occ) {
        return occ == Occ.ZERO ? EMP : type.seqType(occ);
    }

    public static SeqType get(Type type, Occ occ, Test kind) {
        return occ == Occ.ZERO || kind == null ? SeqType.get(type, occ) : new SeqType(type, occ, kind);
    }

    public SeqType with(Type tp, Occ oc) {
        return this.type.eq(tp) && this.occ == oc && this.kind == null ? this : SeqType.get(tp, oc);
    }

    public SeqType with(Occ oc) {
        return oc == this.occ ? this : SeqType.get(this.type, oc, this.kind);
    }

    public SeqType with(Type tp) {
        return this.type.eq(tp) ? this : SeqType.get(tp, this.occ, this.kind);
    }

    public boolean instance(Value value) {
        long size = value.size();
        if (!this.occ.check(size)) {
            return false;
        }
        for (long i = 0L; i < size; ++i) {
            if (!this.instance(value.itemAt(i))) {
                return false;
            }
            if (i == 0L && value.homogeneous()) break;
        }
        return true;
    }

    public boolean instance(Item item) {
        return item.instanceOf(this.type) && (this.kind == null || this.kind.eq(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value cast(Item item, QueryContext qc, StaticContext sc, InputInfo info, boolean error) throws QueryException {
        if (item.type.eq(this.type)) {
            return item;
        }
        try {
            if (!error && info != null) {
                info.internal(true);
            }
            Value value = this.type.cast(item, qc, sc, info);
            if (this.kind != null) {
                for (Item it : value) {
                    if (this.kind.eq(item)) continue;
                    throw QueryError.typeError(it, this.type, info);
                }
            }
            Value value2 = value;
            return value2;
        }
        catch (QueryException ex) {
            if (error) {
                throw ex;
            }
            Value value = null;
            return value;
        }
        finally {
            if (!error && info != null) {
                info.internal(false);
            }
        }
    }

    public Value cast(Value value, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        Item item;
        long vs = value.size();
        if (!this.occ.check(vs)) {
            throw QueryError.INVTYPE_X_X_X.get(info, value.seqType(), this, value);
        }
        if (value.isEmpty()) {
            return Empty.SEQ;
        }
        if (value instanceof Item) {
            return this.cast((Item)value, qc, sc, info, true);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        BasicIter<Item> iter = value.iter();
        while ((item = qc.next(iter)) != null) {
            vb.add(this.cast(item, qc, sc, info, true));
        }
        return vb.value();
    }

    public void treat(Value value, QNm name, InputInfo info, QueryContext qc) throws QueryException {
        if (value.seqType().instanceOf(this)) {
            return;
        }
        int size = (int)value.size();
        if (!this.occ.check(size)) {
            throw QueryError.typeError(value, this, name, info);
        }
        if (size == 0) {
            return;
        }
        boolean ins = this.instance(value.itemAt(0L));
        if (!value.homogeneous()) {
            for (int i = 1; ins && i < size; ++i) {
                qc.checkStop();
                ins = this.instance(value.itemAt(i));
            }
        }
        if (!ins) {
            throw QueryError.typeError(value, this, name, info);
        }
    }

    public Value promote(Value value, QNm name, QueryContext qc, StaticContext sc, InputInfo info, boolean opt) throws QueryException {
        long size = value.size();
        if (!this.occ.check(size)) {
            throw QueryError.typeError(value, this, name, info);
        }
        if (size == 0L) {
            return Empty.SEQ;
        }
        ItemList items = null;
        for (long i = 0L; i < size; ++i) {
            qc.checkStop();
            Item item = value.itemAt(i);
            if (this.instance(item)) {
                if (i == 0L && value.homogeneous()) {
                    return value;
                }
                if (items == null) continue;
                items.add(item);
                continue;
            }
            if (items == null) {
                items = new ItemList(size);
                int j = 0;
                while ((long)j < i) {
                    items.add(value.itemAt(j));
                    ++j;
                }
            }
            this.promote(item, name, items, qc, sc, info, opt);
        }
        return items != null ? items.value(this.type) : value;
    }

    public void promote(Item item, QNm name, ItemList items, QueryContext qc, StaticContext sc, InputInfo info, boolean opt) throws QueryException {
        if (this.type instanceof AtomType) {
            Item item1;
            BasicIter<Item> iter = item.atomValue(qc, info).iter();
            while ((item1 = qc.next(iter)) != null) {
                Type tp = item1.type;
                if (tp.instanceOf(this.type)) {
                    items.add(item1);
                    continue;
                }
                if (tp == AtomType.ATM) {
                    Item item2;
                    if (this.type.nsSensitive()) {
                        throw QueryError.NSSENS_X_X.get(info, item.type, this.type);
                    }
                    BasicIter<Item> iter2 = this.type.cast(item1, qc, sc, info).iter();
                    while ((item2 = qc.next(iter2)) != null) {
                        items.add(item2);
                    }
                    continue;
                }
                if (this.type == AtomType.DBL && (tp == AtomType.FLT || tp.instanceOf(AtomType.DEC))) {
                    items.add(Dbl.get(item1.dbl(info)));
                    continue;
                }
                if (this.type == AtomType.FLT && tp.instanceOf(AtomType.DEC)) {
                    items.add(Flt.get(item1.flt(info)));
                    continue;
                }
                if (this.type == AtomType.STR && item1 instanceof Uri) {
                    items.add(Str.get(item1.string(info)));
                    continue;
                }
                throw QueryError.typeError(item, this.with(Occ.ONE), name, info);
            }
        } else if (item instanceof FItem && this.type instanceof FuncType) {
            items.add(((FItem)item).coerceTo((FuncType)this.type, qc, info, opt));
        } else {
            throw QueryError.typeError(item, this.with(Occ.ONE), name, info);
        }
    }

    public boolean promotable(SeqType st) {
        if (this.intersect(st) != null) {
            return true;
        }
        if (this.occ.intersect(st.occ) == null) {
            return false;
        }
        Type to = st.type;
        if (to instanceof AtomType) {
            if (this.type.isUntyped()) {
                return !to.nsSensitive();
            }
            return to == AtomType.DBL && (this.couldBe(AtomType.FLT) || this.couldBe(AtomType.DEC)) || to == AtomType.FLT && this.couldBe(AtomType.DEC) || to == AtomType.STR && this.couldBe(AtomType.URI);
        }
        return st.type instanceof FuncType && this.type instanceof FuncType;
    }

    private boolean couldBe(Type tp) {
        return this.type.intersect(tp) != null;
    }

    public SeqType union(SeqType st) {
        Type tp = this.type.eq(st.type) || st.zero() ? this.type : (this.zero() ? st.type : this.type.union(st.type));
        Occ oc = this.occ.union(st.occ);
        return SeqType.get(tp, oc);
    }

    public SeqType add(SeqType st) {
        return this.zero() ? st : (st.zero() ? this : SeqType.get(this.type.union(st.type), this.occ.add(st.occ)));
    }

    public SeqType intersect(SeqType st) {
        Type tp = this.type.intersect(st.type);
        if (tp == null) {
            return null;
        }
        Occ oc = this.occ.intersect(st.occ);
        if (oc == null) {
            return null;
        }
        if (this.kind == null || st.kind == null || this.kind.equals(st.kind)) {
            return SeqType.get(tp, oc, this.kind != null ? this.kind : st.kind);
        }
        Test kn = this.kind.intersect(st.kind);
        return kn == null ? null : SeqType.get(tp, oc, kn);
    }

    public boolean zeroOrOne() {
        return this.occ.max <= 1;
    }

    public boolean zero() {
        return this.occ == Occ.ZERO;
    }

    public boolean one() {
        return this.occ == Occ.ONE;
    }

    public boolean oneNoArray() {
        return this.one() && !this.mayBeArray();
    }

    public boolean oneOrMore() {
        return this.occ.min >= 1;
    }

    public boolean mayBeEmpty() {
        return this.occ.min == 0;
    }

    public boolean mayBeNumber() {
        return !this.zero() && (this.type.isNumber() || AtomType.AAT.instanceOf(this.type));
    }

    public boolean mayBeArray() {
        return !this.zero() && !this.type.instanceOf(AtomType.AAT) && !(this.type instanceof ListType) && !(this.type instanceof MapType) && !(this.type instanceof NodeType);
    }

    public boolean instanceOf(SeqType st) {
        Type type1 = this.type;
        Type type2 = st.type;
        Test kind1 = this.kind;
        Test kind2 = st.kind;
        return (type2 == AtomType.ITEM || type1.instanceOf(type2)) && this.occ.instanceOf(st.occ) && (kind2 == null || kind1 != null && kind1.intersect(kind2) != null);
    }

    public boolean eq(SeqType st) {
        return this == st || this.type.eq(st.type) && this.occ == st.occ && Objects.equals(this.kind, st.kind);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof SeqType && this.eq((SeqType)obj);
    }

    public String typeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.zero() ? "empty-sequence()" : this.type);
        if (this.kind != null) {
            sb.deleteCharAt(sb.length() - 1).append(this.kind).append(')');
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.one() && this.type instanceof FuncType) {
            sb.append('(').append(this.typeString()).append(')');
        } else {
            sb.append(this.typeString());
        }
        if (!(this.type instanceof ListType)) {
            sb.append((Object)this.occ);
        }
        return sb.toString();
    }
}

