/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.ArrayList;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.SubSeq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public abstract class Seq
extends Value {
    public boolean homo;
    protected long size;

    protected Seq(long size, Type type) {
        super(type);
        this.size = size;
        this.homo = type != AtomType.ITEM;
    }

    @Override
    public Object toJava() throws QueryException {
        ArrayList<Object> obj = new ArrayList<Object>((int)this.size);
        for (Item item : this) {
            obj.add(item.toJava());
        }
        return obj.toArray();
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Item item(QueryContext qc, InputInfo info) throws QueryException {
        throw QueryError.SEQFOUND_X.get(info, this);
    }

    @Override
    public final Item test(QueryContext qc, InputInfo info) throws QueryException {
        return this.ebv(qc, info);
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return Seq.this.itemAt(i);
            }

            @Override
            public Value value() {
                return Seq.this;
            }

            @Override
            public Value value(QueryContext qc) {
                return this.value();
            }
        };
    }

    @Override
    public final Value subSequence(long start, long length, QueryContext qc) {
        return length == 0L ? Empty.SEQ : (length == 1L ? this.itemAt(start) : (length == this.size() ? this : this.subSeq(start, length, qc)));
    }

    protected Seq subSeq(long offset, long length, QueryContext qc) {
        qc.checkStop();
        return new SubSeq(this, offset, length);
    }

    public final Value insertBefore(long pos, Value value, QueryContext qc) {
        long n = value.size();
        return n == 0L ? this : (n == 1L ? this.insert(pos, (Item)value, qc) : this.copyInsert(pos, value, qc));
    }

    public abstract Value insert(long var1, Item var3, QueryContext var4);

    protected Value copyInsert(long pos, Value value, QueryContext qc) {
        long i;
        if (pos == this.size) {
            return new TreeSeqBuilder().add(this, qc).add(value, qc).seq();
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (i = 0L; i < pos; ++i) {
            vb.add(this.itemAt(i));
        }
        vb.add(value);
        for (i = pos; i < this.size; ++i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(this.type);
    }

    public abstract Value remove(long var1, QueryContext var3);

    final Value copyRemove(long pos, QueryContext qc) {
        long i;
        ValueBuilder vb = new ValueBuilder(qc);
        for (i = 0L; i < pos; ++i) {
            vb.add(this.itemAt(i));
        }
        for (i = pos + 1L; i < this.size; ++i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(this.type);
    }

    @Override
    public final int hash(InputInfo info) throws QueryException {
        int h = 1;
        long v = Math.min(this.size, 5L);
        while (--v >= 0L) {
            h = 31 * h + this.itemAt(v).hash(info);
        }
        return h;
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo info) throws QueryException {
        Iter ir = this.atomIter(qc, info);
        Item it = ir.next();
        if (it != null && ir.next() != null) {
            throw QueryError.SEQFOUND_X.get(info, this);
        }
        return it;
    }

    @Override
    public boolean equals(Object obj) {
        Item item1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Seq)) {
            return false;
        }
        Seq s = (Seq)obj;
        if (this.size != s.size) {
            return false;
        }
        BasicIter<Item> iter1 = this.iter();
        BasicIter<Item> iter2 = s.iter();
        while ((item1 = iter1.next()) != null) {
            if (item1.equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plan(FElem plan) {
        FElem elem = this.planElem("size", this.size, "type", this.seqType());
        Seq.addPlan(plan, elem, new ExprInfo[0]);
        for (long i = 0L; i < this.size; ++i) {
            if (i == 3L && i + 1L < this.size) {
                elem.add(new FElem("etc"));
                break;
            }
            this.itemAt(i).plan(elem);
        }
    }

    @Override
    public final SeqType seqType() {
        return SeqType.get(this.type, Occ.ONE_MORE);
    }

    @Override
    public String description() {
        return this.type + " " + "sequence";
    }

    @Override
    public final String toErrorString() {
        return this.toString(true);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean error) {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while ((long)i < this.size) {
            sb.append(i == 0 ? "" : ", ");
            Item item = this.itemAt(i);
            sb.append(error ? item.toErrorString() : item.toString());
            if (sb.length() > 16 && (long)(i + 1) != this.size) {
                sb.append(", ").append("...");
                break;
            }
            ++i;
        }
        return sb.append(")").toString();
    }
}

