/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.list.IntList;

public class DBNodeSeq
extends NativeSeq {
    protected final Data data;
    protected final boolean all;
    protected int[] pres;

    protected DBNodeSeq(int[] pres, Data data, Type type, boolean all) {
        super(pres.length, type);
        this.pres = pres;
        this.data = data;
        this.all = all;
    }

    @Override
    public Data data() {
        return this.data;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo info) {
        return this.itemAt(0L);
    }

    @Override
    public boolean iterable() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DBNodeSeq)) {
            return super.equals(obj);
        }
        DBNodeSeq ds = (DBNodeSeq)obj;
        return this.size == ds.size && Arrays.equals(this.pres, ds.pres);
    }

    @Override
    public DBNode itemAt(long pos) {
        return new DBNode(this.data, this.pres[(int)pos]);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo info) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        int s = 0;
        while ((long)s < this.size) {
            vb.add(this.itemAt(s).atomValue(qc, info));
            ++s;
        }
        return vb.value();
    }

    public int[] pres() {
        return this.pres;
    }

    public int pre(int index) {
        return this.pres[index];
    }

    public boolean all() {
        return this.all;
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        int[] tmp = new int[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.pres[i];
        }
        return DBNodeSeq.get(tmp, this.data, this.type, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        int i = 0;
        while ((long)i < this.size) {
            sb.append(i == 0 ? "" : ", ");
            sb.append(Function._DB_OPEN_PRE.args(this.data.meta.name, this.pres[i]).substring(1));
            if (sb.length() > 16 && (long)(i + 1) != this.size) {
                sb.append(", ").append("...");
                break;
            }
            ++i;
        }
        return sb.append(")").toString();
    }

    public static Value get(int[] pres, Data data, Type type, boolean all) {
        return pres.length == 0 ? Empty.SEQ : (pres.length == 1 ? new DBNode(data, pres[0]) : new DBNodeSeq(pres, data, type, all));
    }

    public static Value get(IntList pres, Data data, boolean docs, boolean all) {
        return DBNodeSeq.get(pres.toArray(), data, docs ? NodeType.DOC : NodeType.NOD, all);
    }
}

