/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.Stack;
import org.basex.api.dom.BXNode;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class FNode
extends ANode {
    FNode(NodeType type) {
        super(type);
    }

    @Override
    public byte[] string() {
        if (this.value == null) {
            this.value = Token.EMPTY;
        }
        return this.value;
    }

    @Override
    public abstract FNode deepCopy(MainOptions var1, QueryContext var2);

    @Override
    public FNode finish() {
        return this;
    }

    @Override
    public final boolean is(ANode node) {
        return this.id == node.id;
    }

    @Override
    public final int diff(ANode node) {
        if (node instanceof DBNode) {
            return FNode.diff(this, node);
        }
        return Integer.compare(this.id - node.id, 0);
    }

    @Override
    public final ANode parent() {
        return this.parent;
    }

    @Override
    public final BasicNodeIter ancestor() {
        return new BasicNodeIter(){
            private ANode node;
            {
                this.node = FNode.this;
            }

            @Override
            public ANode next() {
                this.node = this.node.parent();
                return this.node;
            }
        };
    }

    @Override
    public final BasicNodeIter ancestorOrSelf() {
        return new BasicNodeIter(){
            private ANode node;
            {
                this.node = FNode.this;
            }

            @Override
            public ANode next() {
                if (this.node == null) {
                    return null;
                }
                ANode n = this.node;
                this.node = n.parent();
                return n;
            }
        };
    }

    @Override
    public BasicNodeIter attributes() {
        return BasicNodeIter.EMPTY;
    }

    @Override
    public BasicNodeIter children() {
        return BasicNodeIter.EMPTY;
    }

    @Override
    public final FNode parent(ANode par) {
        this.parent = par;
        return this;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public final BasicNodeIter descendant() {
        return this.desc(false);
    }

    @Override
    public final BasicNodeIter descendantOrSelf() {
        return this.desc(true);
    }

    static BasicNodeIter iter(final ANodeList iter) {
        return new BasicNodeIter(){
            int c;

            @Override
            public ANode next() {
                return iter != null && this.c != iter.size() ? (ANode)iter.get(this.c++) : null;
            }

            @Override
            public ANode get(long i) {
                return (ANode)iter.get((int)i);
            }

            @Override
            public long size() {
                return iter.size();
            }

            @Override
            public Value value() {
                return iter.value();
            }

            @Override
            public Value value(QueryContext qc) {
                return this.value();
            }
        };
    }

    final byte[] string(ANodeList iter) {
        if (this.value == null) {
            TokenBuilder tb = new TokenBuilder();
            for (ANode nc : iter) {
                if (nc.type != NodeType.ELM && nc.type != NodeType.TXT) continue;
                tb.add(nc.string());
            }
            this.value = tb.finish();
        }
        return this.value;
    }

    private BasicNodeIter desc(final boolean self) {
        return new BasicNodeIter(){
            private final Stack<BasicNodeIter> iters = new Stack();
            private ANode last;

            @Override
            public ANode next() {
                BasicNodeIter iter = this.last != null ? this.last.children() : (self ? FNode.this.self() : FNode.this.children());
                this.last = iter.next();
                if (this.last == null) {
                    while (!this.iters.isEmpty()) {
                        this.last = this.iters.peek().next();
                        if (this.last == null) {
                            this.iters.pop();
                            continue;
                        }
                        break;
                    }
                } else {
                    this.iters.add(iter);
                }
                return this.last;
            }
        };
    }

    @Override
    public final BasicNodeIter followingSibling() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANode n;
                    ANode r = FNode.this.parent();
                    if (r == null) {
                        return null;
                    }
                    this.iter = r.children();
                    while ((n = this.iter.next()) != null && !n.is(FNode.this)) {
                    }
                }
                return this.iter.next();
            }
        };
    }

    @Override
    public final BasicNodeIter following() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    ANode node = FNode.this;
                    for (ANode par = ((ANode)node).parent(); par != null; par = par.parent()) {
                        BasicNodeIter ir = par.children();
                        if (node.type != NodeType.ATT) {
                            for (ANode nd : ir) {
                                if (nd.is(node)) break;
                            }
                        }
                        for (ANode nd : ir) {
                            list.add(nd.finish());
                            ANode.addDesc(nd.children(), list);
                        }
                        node = par;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FNode)) {
            return false;
        }
        FNode n = (FNode)obj;
        return this.type.eq(n.type) && Token.eq(this.value, n.value) && this.parent == n.parent;
    }

    @Override
    public final BXNode toJava() {
        return BXNode.get(this);
    }
}

