/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryException;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.InputInfo;
import org.basex.util.hash.ASet;

public class HashItemSet
extends ASet
implements ItemSet {
    private int[] hash = new int[8];
    private Item[] items = new Item[8];
    private final boolean eq;

    public HashItemSet(boolean eq) {
        super(8);
        this.eq = eq;
    }

    @Override
    public final boolean add(Item item, InputInfo ii) throws QueryException {
        return !this.check(item, ii, true);
    }

    public final boolean contains(Item item, InputInfo ii) throws QueryException {
        return this.check(item, ii, false);
    }

    private boolean check(Item item, InputInfo ii, boolean add) throws QueryException {
        this.checkSize();
        int h = item.hash(ii);
        int b = h & this.buckets.length - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (this.eq ? this.items[id].eq(item, null, null, ii) : this.items[id].equiv(item, null, ii)) {
                return true;
            }
            id = this.next[id];
        }
        if (add) {
            int s = this.size;
            this.next[s] = this.buckets[b];
            this.items[s] = item;
            this.hash[s] = h;
            this.buckets[b] = s;
            this.size = s + 1;
        }
        return false;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator<Item>(this.items, 1, this.size);
    }

    @Override
    protected int hash(int id) {
        return this.hash[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.items = Array.copy(this.items, new Item[newSize]);
        this.hash = Arrays.copyOf(this.hash, newSize);
    }
}

