/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import org.basex.query.util.fingertree.DeepTree;
import org.basex.query.util.fingertree.EmptyTree;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.InnerNode;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.SingletonTree;
import org.basex.util.Util;

final class FingerTreeIterator<E>
implements ListIterator<E> {
    private final long n;
    private long index;
    private DeepTree<?, E>[] trees;
    private int deepPos;
    private int tTop = -1;
    private InnerNode<?, E>[] nodes;
    private int[] poss;
    private int nTop = -1;
    private Node<E, E> leaf;
    private int leafPos;

    FingerTreeIterator(Node<?, E> root, long start) {
        this.n = root.size();
        this.index = start;
        if (root instanceof InnerNode) {
            this.nodes = new InnerNode[8];
            this.poss = new int[8];
            this.nTop = 0;
            this.nodes[0] = (InnerNode)root;
        } else {
            this.leaf = root;
            this.leafPos = (int)start;
        }
        assert (start >= 0L && start <= this.n);
    }

    FingerTreeIterator(DeepTree<?, E> tree, long start) {
        this.n = tree.size();
        this.index = start;
        this.trees = new DeepTree[8];
        this.trees[0] = tree;
        this.tTop = 0;
        this.nodes = new InnerNode[8];
        this.poss = new int[8];
        this.nTop = -1;
    }

    static <E> ListIterator<E> get(FingerTree<?, E> tree, long start) {
        if (tree.isEmpty()) {
            return Collections.emptyListIterator();
        }
        if (tree instanceof SingletonTree) {
            return new FingerTreeIterator<E>(tree.head(), start);
        }
        return new FingerTreeIterator<E>((DeepTree)tree, start);
    }

    private void init() {
        Node node;
        Object curr;
        long pos;
        block11: {
            pos = Math.min(this.index, this.n - 1L);
            if (this.tTop >= 0) {
                while (true) {
                    curr = this.trees[this.tTop];
                    if (pos < ((DeepTree)curr).leftSize) {
                        long size;
                        Node<N, E>[] left = ((DeepTree)curr).left;
                        int i = 0;
                        while (pos >= (size = (node = left[i]).size())) {
                            pos -= size;
                            ++i;
                        }
                        this.deepPos = i - left.length;
                        break block11;
                    }
                    FingerTree mid = ((DeepTree)curr).middle;
                    long midSize = mid.size();
                    if ((pos -= ((DeepTree)curr).leftSize) >= midSize) {
                        long size;
                        pos -= midSize;
                        Node<N, E>[] right = ((DeepTree)curr).right;
                        int i = 0;
                        while (pos >= (size = (node = right[i]).size())) {
                            pos -= size;
                            ++i;
                        }
                        this.deepPos = i + 1;
                        break block11;
                    }
                    if (mid instanceof SingletonTree) {
                        node = mid.head();
                        this.deepPos = 0;
                        break block11;
                    }
                    if (++this.tTop == this.trees.length) {
                        this.trees = Arrays.copyOf(this.trees, 2 * this.tTop);
                    }
                    this.trees[this.tTop] = (DeepTree)mid;
                }
            }
            this.deepPos = 0;
            node = this.nodes[0];
            this.nTop = -1;
        }
        curr = node;
        while (curr instanceof InnerNode) {
            long size;
            InnerNode inner = (InnerNode)curr;
            int idx = 0;
            Object sub = inner.getSub(0);
            while (pos >= (size = sub.size())) {
                pos -= size;
                sub = inner.getSub(++idx);
            }
            if (++this.nTop == this.nodes.length) {
                this.nodes = Arrays.copyOf(this.nodes, 2 * this.nTop);
                this.poss = Arrays.copyOf(this.poss, 2 * this.nTop);
            }
            this.nodes[this.nTop] = inner;
            this.poss[this.nTop] = idx;
            curr = sub;
        }
        this.leaf = curr;
        this.leafPos = (int)(this.index < this.n ? pos : pos + 1L);
    }

    @Override
    public int nextIndex() {
        return (int)this.index;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.n;
    }

    @Override
    public E next() {
        Node start;
        if (this.leaf == null) {
            this.init();
        }
        ++this.index;
        if (this.leafPos < this.leaf.arity()) {
            return this.leaf.getSub(this.leafPos++);
        }
        while (this.nTop >= 0 && this.poss[this.nTop] == this.nodes[this.nTop].arity() - 1) {
            --this.nTop;
        }
        if (this.nTop >= 0) {
            int n = this.nTop;
            int n2 = this.poss[n] + 1;
            this.poss[n] = n2;
            start = this.nodes[this.nTop].getSub(n2);
        } else {
            DeepTree<?, E> curr = this.trees[this.tTop];
            if (this.deepPos < -1) {
                ++this.deepPos;
                start = curr.left[curr.left.length + this.deepPos];
            } else if (this.deepPos == -1) {
                FingerTree mid = curr.middle;
                if (mid instanceof EmptyTree) {
                    this.deepPos = 1;
                    start = curr.right[0];
                } else if (mid instanceof SingletonTree) {
                    this.deepPos = 0;
                    start = ((SingletonTree)mid).elem;
                } else {
                    DeepTree deep = (DeepTree)mid;
                    if (++this.tTop == this.trees.length) {
                        DeepTree[] newTrees = new DeepTree[2 * this.tTop];
                        System.arraycopy(this.trees, 0, newTrees, 0, this.tTop);
                        this.trees = newTrees;
                    }
                    this.trees[this.tTop] = deep;
                    this.deepPos = -deep.left.length;
                    start = deep.left[0];
                }
            } else if (this.deepPos == 0) {
                this.deepPos = 1;
                start = curr.right[0];
            } else {
                int p = this.deepPos - 1;
                if (p < curr.right.length - 1) {
                    ++this.deepPos;
                    start = curr.right[p + 1];
                } else {
                    this.trees[this.tTop] = null;
                    this.deepPos = 0;
                    --this.tTop;
                    start = this.trees[this.tTop].right[0];
                    this.deepPos = 1;
                }
            }
        }
        Object sub = start;
        while (sub instanceof InnerNode) {
            if (++this.nTop == this.nodes.length) {
                InnerNode[] newNodes = new InnerNode[2 * this.nTop];
                System.arraycopy(this.nodes, 0, newNodes, 0, this.nTop);
                this.nodes = newNodes;
                this.poss = Arrays.copyOf(this.poss, 2 * this.nTop);
            }
            this.nodes[this.nTop] = (InnerNode)sub;
            this.poss[this.nTop] = 0;
            sub = this.nodes[this.nTop].getSub(0);
        }
        this.leaf = sub;
        this.leafPos = 1;
        return this.leaf.getSub(0);
    }

    @Override
    public int previousIndex() {
        return (int)(this.index - 1L);
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0L;
    }

    @Override
    public E previous() {
        Node start;
        if (this.leaf == null) {
            this.init();
        }
        --this.index;
        if (this.leafPos > 0) {
            return this.leaf.getSub(--this.leafPos);
        }
        while (this.nTop >= 0 && this.poss[this.nTop] == 0) {
            --this.nTop;
        }
        if (this.nTop >= 0) {
            int n = this.nTop;
            int n2 = this.poss[n] - 1;
            this.poss[n] = n2;
            start = this.nodes[this.nTop].getSub(n2);
        } else {
            DeepTree<?, E> curr = this.trees[this.tTop];
            if (this.deepPos > 1) {
                --this.deepPos;
                start = curr.right[this.deepPos - 1];
            } else if (this.deepPos == 1) {
                FingerTree mid = curr.middle;
                if (mid instanceof EmptyTree) {
                    int l = curr.left.length;
                    start = curr.left[l - 1];
                    this.deepPos = -1;
                } else if (mid instanceof SingletonTree) {
                    start = ((SingletonTree)mid).elem;
                    this.deepPos = 0;
                } else {
                    DeepTree deep = (DeepTree)mid;
                    if (++this.tTop == this.trees.length) {
                        DeepTree[] newTrees = new DeepTree[2 * this.tTop];
                        System.arraycopy(this.trees, 0, newTrees, 0, this.tTop);
                        this.trees = newTrees;
                    }
                    this.trees[this.tTop] = deep;
                    int r = deep.right.length;
                    start = deep.right[r - 1];
                    this.deepPos = r;
                }
            } else if (this.deepPos == 0) {
                start = curr.left[curr.left.length - 1];
                this.deepPos = -1;
            } else {
                int l = curr.left.length;
                int p = l + this.deepPos;
                if (p > 0) {
                    --this.deepPos;
                    start = curr.left[p - 1];
                } else {
                    this.trees[this.tTop] = null;
                    --this.tTop;
                    Node<N, E>[] left = this.trees[this.tTop].left;
                    start = left[left.length - 1];
                    this.deepPos = -1;
                }
            }
        }
        Object sub = start;
        while (sub instanceof InnerNode) {
            if (++this.nTop == this.nodes.length) {
                InnerNode[] newNodes = new InnerNode[2 * this.nTop];
                System.arraycopy(this.nodes, 0, newNodes, 0, this.nTop);
                this.nodes = newNodes;
                this.poss = Arrays.copyOf(this.poss, 2 * this.nTop);
            }
            this.nodes[this.nTop] = (InnerNode)sub;
            this.poss[this.nTop] = sub.arity() - 1;
            sub = this.nodes[this.nTop].getSub(this.poss[this.nTop]);
        }
        this.leaf = sub;
        this.leafPos = sub.arity() - 1;
        return this.leaf.getSub(this.leafPos);
    }

    @Override
    public void set(E e) {
        throw Util.notExpected();
    }

    @Override
    public void add(E e) {
        throw Util.notExpected();
    }

    @Override
    public void remove() {
        throw Util.notExpected();
    }
}

