/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.ArrayList;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.UserUpdate;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public abstract class UserPermUpdate
extends UserUpdate {
    private final ArrayList<Perm> perms;
    protected final StringList patterns;

    protected UserPermUpdate(UpdateType type, User user, ArrayList<Perm> perms, StringList patterns, QueryContext qc, InputInfo info) throws QueryException {
        super(type, user, qc, info);
        this.perms = perms;
        this.patterns = patterns;
        StringList tmp = new StringList();
        for (String pattern : patterns) {
            if (tmp.contains(pattern)) {
                throw pattern.isEmpty() ? QueryError.USER_UPDATE3_X_X.get(info, user.name(), this.operation()) : QueryError.USER_UPDATE2_X.get(info, pattern);
            }
            tmp.add(pattern);
        }
    }

    @Override
    public void merge(Update update) throws QueryException {
        UserPermUpdate up = (UserPermUpdate)update;
        if (!this.name().equals(up.name())) {
            return;
        }
        for (String pattern : up.patterns) {
            if (!this.patterns.contains(pattern)) continue;
            throw pattern.isEmpty() ? QueryError.USER_UPDATE1_X_X.get(this.info, this.name(), this.operation()) : QueryError.USER_UPDATE2_X.get(this.info, pattern);
        }
    }

    protected final void grant() {
        int ps = this.perms.size();
        for (int p = 0; p < ps; ++p) {
            this.user.perm(this.perms.get(p), (String)this.patterns.get(p));
        }
    }
}

