/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.zip;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.zip.ZipZipFile;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class ZipUpdateEntries
extends ZipZipFile {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        IOFile out;
        ANode elm = this.toElem(this.exprs[0], qc);
        if (!elm.qname().eq(Q_FILE)) {
            throw QueryError.ZIP_UNKNOWN_X.get(this.info, elm.qname());
        }
        String in = this.attribute(elm, HREF, true);
        IOFile target = new IOFile(Token.string(this.toToken(this.exprs[1], qc)));
        while ((out = new IOFile(target.path() + new Random().nextInt(Integer.MAX_VALUE))).exists()) {
        }
        if (!new IOFile(in).exists()) {
            throw QueryError.ZIP_NOTFOUND_X.get(this.info, in);
        }
        boolean ok = true;
        try (ZipFile zf = new ZipFile(in);){
            try (FileOutputStream fos = new FileOutputStream(out.path());
                 ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
                this.create(zos, elm.children(), "", zf, qc);
            }
            catch (IOException ex) {
                ok = false;
                throw QueryError.ZIP_FAIL_X.get(this.info, ex);
            }
        }
        catch (IOException ex) {
            throw QueryError.ZIP_FAIL_X.get(this.info, ex);
        }
        finally {
            if (ok) {
                target.delete();
                out.rename(target);
            } else {
                out.delete();
            }
        }
        return null;
    }
}

