/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xquery;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.Module;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class XQueryParse
extends StandardFunc {
    private static final byte[] LIBRARY_MODULE = Token.token("LibraryModule");
    private static final byte[] MAIN_MODULE = Token.token("MainModule");
    private static final byte[] UPDATING = Token.token("updating");
    private static final byte[] PREFIX = Token.token("prefix");
    private static final byte[] URI = Token.token("uri");

    @Override
    public FElem item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.parse(qc, this.toToken(this.exprs[0], qc), null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final FElem parse(QueryContext qc, byte[] query, String path) throws QueryException {
        XQueryOptions opts = this.toOptions(1, new XQueryOptions(), qc);
        String bu = opts.get(XQueryOptions.BASE_URI);
        String uri = bu != null ? bu : (path != null ? path : Token.string(this.sc.baseURI().string()));
        try (QueryContext qctx = new QueryContext(qc.context);){
            FElem root;
            Module mod = qctx.parse(Token.string(query), uri, null);
            if (mod instanceof LibraryModule) {
                LibraryModule lib = (LibraryModule)mod;
                root = new FElem(LIBRARY_MODULE);
                root.add(PREFIX, lib.name.string());
                root.add(URI, lib.name.uri());
            } else {
                root = new FElem(MAIN_MODULE);
                root.add(UPDATING, Token.token(qctx.updating));
            }
            if (opts.get(XQueryOptions.COMPILE).booleanValue()) {
                qctx.compile();
            }
            if (opts.get(XQueryOptions.PLAN).booleanValue()) {
                root.add(qctx.plan());
            }
            FElem fElem = root;
            return fElem;
        }
        catch (QueryException ex) {
            if (opts.get(XQueryOptions.PASS) != false) throw ex;
            ex.info(this.info);
            throw ex;
        }
    }

    public static class XQueryOptions
    extends Options {
        public static final BooleanOption PLAN = new BooleanOption("plan", true);
        public static final BooleanOption COMPILE = new BooleanOption("compile", false);
        public static final BooleanOption PASS = new BooleanOption("pass", false);
        public static final StringOption BASE_URI = new StringOption("base-uri");
    }
}

