/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.web;

import java.util.HashMap;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public final class WebResponseHeader
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        HashMap<String, String> output = this.toOptions(0, new Options(), qc).free();
        HashMap<String, String> headers = this.toOptions(1, new Options(), qc).free();
        ResponseOptions response = this.toOptions(2, new ResponseOptions(), qc);
        SerializerOptions so = SerializerMode.DEFAULT.get();
        for (String entry : output.keySet()) {
            if (so.option(entry) != null) continue;
            throw QueryError.INVALIDOPTION_X.get(this.info, entry);
        }
        FElem hresp = new FElem(new QNm(QueryText.HTTP_PREFIX, "response", QueryText.HTTP_URI));
        headers.forEach((name, value) -> {
            if (!value.isEmpty()) {
                hresp.add(new FElem(new QNm(QueryText.HTTP_PREFIX, "header", QueryText.HTTP_URI)).add("name", (String)name).add("value", (String)value));
            }
        });
        FElem oseri = new FElem(new QNm(QueryText.OUTPUT_PREFIX, QueryText.SERIALIZATION_PARAMETERS, QueryText.OUTPUT_URI));
        output.forEach((name, value) -> {
            if (!value.isEmpty()) {
                oseri.add(new FElem(new QNm(QueryText.OUTPUT_PREFIX, (String)name, QueryText.OUTPUT_URI)).add("value", (String)value));
            }
        });
        FElem rest = new FElem(new QNm(QueryText.REST_PREFIX, "response", QueryText.REST_URI));
        for (Option<?> o : response) {
            if (!response.contains(o)) continue;
            rest.add(o.name(), response.get(o).toString());
        }
        return rest.add(hresp).add(oseri);
    }

    public static class ResponseOptions
    extends Options {
        public static final NumberOption STATUS = new NumberOption("status");
        public static final StringOption MESSAGE = new StringOption("message");
    }
}

