/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.unit;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.unit.Constants;
import org.basex.query.func.unit.UnitException;
import org.basex.query.iter.Iter;
import org.basex.query.scope.MainModule;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.Performance;
import org.basex.util.Token;

final class Unit {
    private final Context ctx;
    private final IOFile file;
    private final Job job;
    private String input;
    private StaticFunc current;
    int failures;
    int errors;
    int skipped;
    int tests;

    Unit(IOFile file, Context ctx, Job job) {
        this.file = file;
        this.ctx = ctx;
        this.job = job;
    }

    public void test(FElem suites) throws IOException {
        FElem suite = new FElem(Constants.TESTSUITE).add(Constants.NAME, this.file.url());
        ArrayList<StaticFunc> beforeModule = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> afterModule = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> before = new ArrayList<StaticFunc>(0);
        ArrayList<StaticFunc> after = new ArrayList<StaticFunc>(0);
        ArrayList<QNm> beforeFilter = new ArrayList<QNm>();
        ArrayList<QNm> afterFilter = new ArrayList<QNm>();
        ArrayList<StaticFunc> test = new ArrayList<StaticFunc>(0);
        Performance perf = new Performance();
        try (QueryContext qc = new QueryContext(this.ctx);){
            this.input = Token.string(this.file.read());
            qc.parse(this.input, this.file.path(), null);
            for (StaticFunc sf : qc.funcs.funcs()) {
                Ann a;
                Ann b;
                AnnList anns = sf.anns;
                boolean xq = false;
                for (Ann ann : anns) {
                    xq |= ann.sig != null && Token.eq(ann.sig.uri, QueryText.UNIT_URI);
                }
                if (!xq) continue;
                if (anns.contains(Annotation.PRIVATE)) {
                    throw QueryError.UNIT_PRIVATE_X.get(null, new Object[]{sf.name.local()});
                }
                if (sf.params.length > 0) {
                    throw QueryError.UNIT_NOARGS_X.get(null, new Object[]{sf.name.local()});
                }
                if (anns.contains(Annotation._UNIT_BEFORE_MODULE)) {
                    beforeModule.add(sf);
                }
                if (anns.contains(Annotation._UNIT_AFTER_MODULE)) {
                    afterModule.add(sf);
                }
                if ((b = anns.get(Annotation._UNIT_BEFORE)) != null) {
                    before.add(sf);
                    beforeFilter.add(Unit.name(sf, b));
                }
                if ((a = anns.get(Annotation._UNIT_AFTER)) != null) {
                    after.add(sf);
                    afterFilter.add(Unit.name(sf, a));
                }
                if (!anns.contains(Annotation._UNIT_TEST)) continue;
                test.add(sf);
            }
            for (StaticFunc sf : beforeModule) {
                this.eval(sf);
            }
            for (StaticFunc sf : test) {
                AnnList anns = sf.anns;
                Ann ann = anns.get(Annotation._UNIT_TEST);
                Item[] args = ann.args();
                int vs = args.length;
                QNm code = null;
                if (vs == 2 && Token.eq(Constants.EXPECTED, args[0].string(null))) {
                    code = QNm.resolve(args[1].string(null), QueryText.ERROR_URI, sf.sc, sf.info);
                } else if (vs != 0) {
                    throw QueryError.BASEX_ANNOTATION2_X_X.get(ann.info, ann, QueryError.arguments(vs));
                }
                FElem testcase = new FElem(Constants.TESTCASE).add(Constants.NAME, sf.name.local());
                ++this.tests;
                Performance perf2 = new Performance();
                Ann ignore = anns.get(Annotation._UNIT_IGNORE);
                if (ignore == null) {
                    try {
                        QNm name;
                        int i;
                        int l = before.size();
                        for (i = 0; i < l; ++i) {
                            name = (QNm)beforeFilter.get(i);
                            if (name != null && !name.eq(sf.name)) continue;
                            this.eval((StaticFunc)before.get(i));
                        }
                        this.eval(sf);
                        l = after.size();
                        for (i = 0; i < l; ++i) {
                            name = (QNm)afterFilter.get(i);
                            if (name != null && !name.eq(sf.name)) continue;
                            this.eval((StaticFunc)after.get(i));
                        }
                        if (code != null) {
                            ++this.failures;
                            testcase.add(new FElem(Constants.FAILURE).add(new FElem(Constants.EXPECTED).add(code.prefixId())));
                        }
                    }
                    catch (QueryException ex) {
                        this.addError(ex, testcase, code);
                    }
                } else {
                    Item[] iargs = ignore.args();
                    testcase.add(Constants.SKIPPED, iargs.length == 0 ? Token.EMPTY : iargs[0].string(null));
                    ++this.skipped;
                }
                testcase.add(Constants.TIME, Unit.time(perf2));
                suite.add(testcase);
            }
            for (StaticFunc sf : afterModule) {
                this.eval(sf);
            }
        }
        catch (QueryException ex) {
            if (this.current == null) {
                this.addError(ex, suite, null);
            }
            FElem tc = new FElem(Constants.TESTINIT).add(Constants.NAME, this.current.name.local()).add(Constants.TIME, Unit.time(perf));
            suite.add(tc);
            this.addError(ex, tc, null);
        }
        if (suite.hasChildren()) {
            suite.add(Constants.TIME, Unit.time(perf));
            suite.add(Constants.TESTS, Token.token(this.tests));
            suite.add(Constants.FAILURES, Token.token(this.failures));
            suite.add(Constants.ERRORS, Token.token(this.errors));
            suite.add(Constants.SKIPPED, Token.token(this.skipped));
            suites.add(suite);
        }
    }

    private static QNm name(StaticFunc sf, Ann ann) throws QueryException {
        byte[] name;
        Item[] args = ann.args();
        if (args.length != 0 && (name = args[0].string(null)).length != 0) {
            return QNm.resolve(name, sf.name.uri(), sf.sc, sf.info);
        }
        return null;
    }

    private void addError(QueryException ex, FElem testcase, QNm code) {
        QNm name = ex.qname();
        if (code == null || !code.eq(name)) {
            FElem error;
            boolean fail = QueryError.UNIT_FAIL.eq(name);
            if (fail) {
                ++this.failures;
                error = new FElem(Constants.FAILURE);
            } else {
                ++this.errors;
                error = new FElem(Constants.ERROR);
            }
            error.add(Constants.LINE, Token.token(ex.line()));
            error.add(Constants.COLUMN, Token.token(ex.column()));
            String url = IO.get(ex.file()).url();
            if (!this.file.url().equals(url)) {
                error.add(Constants.URI, url);
            }
            if (ex instanceof UnitException) {
                UnitException ue = (UnitException)ex;
                error.add(Unit.element(ue.returned, Constants.RETURNED, ue.count));
                error.add(Unit.element(ue.expected, Constants.EXPECTED, ue.count));
            } else if (!fail) {
                error.add(Constants.TYPE, ex.qname().prefixId(QueryText.ERROR_URI));
            }
            Value value = ex.value();
            if (value instanceof Item) {
                error.add(Unit.element((Item)value, Constants.INFO, -1));
            } else {
                error.add(new FElem(Constants.INFO).add(ex.getLocalizedMessage()));
            }
            testcase.add(error);
        }
    }

    private static FElem element(Item item, byte[] name, int count) {
        FElem exp = new FElem(name);
        if (item != null) {
            if (item instanceof ANode) {
                exp.add((ANode)item);
            } else {
                try {
                    exp.add(item.string(null));
                }
                catch (QueryException ignored) {
                    exp.add(QueryError.chop(item.toString(), null));
                }
            }
            if (count != -1) {
                exp.add(Constants.ITEM, Token.token(count)).add(Constants.TYPE, item.type.toString());
            }
        }
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eval(StaticFunc func) throws QueryException {
        this.current = func;
        try (QueryContext qctx = this.job.pushJob(new QueryContext(this.ctx));){
            qctx.parse(this.input, this.file.path(), null);
            qctx.mainModule(MainModule.get(Unit.find(qctx, func), new Expr[0]));
            Iter iter = qctx.iter();
            while (qctx.next(iter) != null) {
            }
        }
        finally {
            this.job.popJob();
        }
    }

    private static StaticFunc find(QueryContext qctx, StaticFunc func) {
        for (StaticFunc sf : qctx.funcs.funcs()) {
            if (!func.info.equals(sf.info)) continue;
            return sf;
        }
        return null;
    }

    static byte[] time(Performance p) {
        return DTDur.get(p.ns() / 1000000L).string(null);
    }
}

