/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.ann.Ann;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.StaticScope;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class XQDoc
extends Inspect {
    private static final byte[] URI = Token.token("http://www.xqdoc.org/1.0");
    private static final byte[] PREFIX = Token.token("xqdoc");
    private final TokenMap nsCache = new TokenMap();

    XQDoc(QueryContext qc, InputInfo info) {
        super(qc, info);
    }

    @Override
    public FElem parse(IO io) throws QueryException {
        Object imp;
        Object pref2;
        QueryParser qp = this.parseQuery(io);
        FElem xqdoc = new FElem(PREFIX, PREFIX, URI).declareNS();
        FElem control = this.elem("control", xqdoc);
        this.elem("date", control).add(this.qc.dateTime().datm.string(this.info));
        this.elem("version", control).add("1.1");
        String type = this.module instanceof LibraryModule ? "library" : "main";
        FElem mod = this.elem("module", xqdoc).add("type", type);
        if (this.module instanceof LibraryModule) {
            QNm name = ((LibraryModule)this.module).name;
            this.elem("uri", mod).add(name.uri());
            this.elem("name", mod).add(io.name());
        } else {
            this.elem("uri", mod).add(io.name());
        }
        this.comment(this.module, mod);
        FElem namespaces = this.elem("namespaces", xqdoc);
        for (Object pref2 : qp.namespaces) {
            this.nsCache.put((byte[])pref2, qp.namespaces.get((byte[])pref2));
        }
        FElem imports = this.elem("imports", xqdoc);
        pref2 = qp.modules.iterator();
        while (pref2.hasNext()) {
            imp = (byte[])pref2.next();
            this.elem("uri", this.elem("import", imports).add("type", "library")).add((byte[])imp);
        }
        FElem variables = this.elem("variables", xqdoc);
        imp = this.module.vars().values().iterator();
        while (imp.hasNext()) {
            StaticVar sv = (StaticVar)imp.next();
            FElem variable = this.elem("variable", variables);
            this.elem("name", variable).add(sv.name.string());
            if (sv.name.hasPrefix()) {
                this.nsCache.put(sv.name.prefix(), sv.name.uri());
            }
            this.comment(sv, variable);
            this.annotations(sv.anns, variable);
            this.type(sv.seqType(), variable);
        }
        FElem functions = this.elem("functions", xqdoc);
        for (StaticFunc sf : this.module.funcs().values()) {
            int al = sf.arity();
            QNm name = sf.funcName();
            FuncType tp = sf.funcType();
            FElem function = this.elem("function", functions).add("arity", Token.token(al));
            this.comment(sf, function);
            this.elem("name", function).add(name.string());
            if (name.hasPrefix()) {
                this.nsCache.put(name.prefix(), name.uri());
            }
            this.annotations(sf.anns, function);
            TokenBuilder tb = new TokenBuilder("declare").add(32).addExt(sf.anns, new Object[0]);
            tb.add("function").add(32).add(name.string()).add("(");
            for (int i = 0; i < al; ++i) {
                Var var = sf.params[i];
                if (i > 0) {
                    tb.add(", ");
                }
                tb.add("$").add(var.name.string()).add(32).add("as").add(32).addExt(tp.argTypes[i], new Object[0]);
            }
            tb.add(")").add(" as " + tp.declType);
            if (sf.expr == null) {
                tb.add(" external");
            }
            this.elem("signature", function).add(tb.finish());
            if (al != 0) {
                FElem fparameters = this.elem("parameters", function);
                for (int a = 0; a < al; ++a) {
                    FElem fparameter = this.elem("parameter", fparameters);
                    Var var = sf.params[a];
                    this.elem("name", fparameter).add(var.name.string());
                    this.type(tp.argTypes[a], fparameter);
                }
            }
            this.type(sf.seqType(), this.elem("return", function));
        }
        for (byte[] pref3 : this.nsCache) {
            FElem namespace = this.elem("namespace", namespaces);
            namespace.add("prefix", pref3).add("uri", this.nsCache.get(pref3));
        }
        return xqdoc;
    }

    @Override
    protected FElem elem(String name, FElem parent) {
        FElem elem = new FElem(PREFIX, Token.token(name), URI);
        parent.add(elem);
        return elem;
    }

    @Override
    protected FElem elem(byte[] name, FElem parent) {
        return Token.eq(name, DOC_TAGS) ? this.elem(Token.string(name), parent) : this.elem("custom", parent).add("tag", name);
    }

    private void comment(StaticScope scope, FElem parent) {
        TokenObjMap<TokenList> map = scope.doc();
        if (map != null) {
            this.comment(map, this.elem("comment", parent));
        }
    }

    private void annotations(AnnList anns, FElem parent) throws QueryException {
        if (!anns.isEmpty()) {
            this.annotation(anns, this.elem("annotations", parent), false);
        }
        for (Ann ann : anns) {
            byte[] uri = ann.name().uri();
            if (uri.length <= 0) continue;
            this.nsCache.put(NSGlobal.prefix(uri), uri);
        }
    }

    private void type(SeqType st, FElem parent) {
        if (st == null) {
            return;
        }
        FElem type = this.elem("type", parent).add(st.typeString());
        String occ = st.occ.toString();
        if (!occ.isEmpty()) {
            type.add("occurrence", occ);
        }
    }
}

