/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.SeqType;
import org.basex.util.Token;
import org.basex.util.Util;

public final class FnError
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) {
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                FnError.this.error(qc);
                return null;
            }
        };
    }

    @Override
    public boolean isVacuous() {
        return true;
    }

    @Override
    protected Expr typeCheck(TypeCheck tc, CompileContext cc) {
        return this;
    }

    public static StandardFunc get(QueryException ex, SeqType st, StaticContext sc) {
        Util.debug(ex);
        StandardFunc sf = Function.ERROR.get(sc, ex.info(), ex.qname(), Str.get(ex.getLocalizedMessage()));
        sf.exprType.assign(st);
        return sf;
    }

    private void error(QueryContext qc) throws QueryException {
        int al = this.exprs.length;
        if (al == 0) {
            throw QueryError.FUNERR1.get(this.info, new Object[0]);
        }
        QNm name = this.toQNm(this.exprs[0], qc, true);
        if (name == null) {
            name = QueryError.FUNERR1.qname();
        }
        String msg = al > 1 ? Token.string(this.toToken(this.exprs[1], qc)) : QueryError.FUNERR1.desc;
        Value value = al > 2 ? this.exprs[2].value(qc) : null;
        throw new QueryException(this.info, name, msg, new Object[0]).value(value);
    }
}

