/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.map.MapKeys;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;

public final class FnCount
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr expr = this.exprs[0];
        if (expr.seqType().zeroOrOne()) {
            return expr.item(qc, this.info) == null ? Int.ZERO : Int.ONE;
        }
        Iter iter = expr.iter(qc);
        long size = iter.size();
        if (size == -1L) {
            do {
                ++size;
            } while (qc.next(iter) != null);
        }
        return Int.get(size);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        long size;
        Expr expr = this.exprs[0];
        if (!expr.has(Flag.NDT) && (size = expr.size()) >= 0L) {
            return Int.get(size);
        }
        if (expr instanceof MapKeys) {
            return cc.function(Function._MAP_SIZE, this.info, ((MapKeys)expr).exprs);
        }
        return this;
    }
}

