/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Item;

public final class FileDelete
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws QueryException, IOException {
        Path path = this.toPath(0, qc);
        if (this.optionalBool(1, qc)) {
            this.delete(path);
        } else {
            Files.delete(path);
        }
        return null;
    }

    private synchronized void delete(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
                for (Path p : paths) {
                    this.delete(p);
                }
            }
        }
        Files.delete(path);
    }
}

