/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbNew;
import org.basex.query.up.Updates;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.db.DBAdd;
import org.basex.query.up.primitives.db.DBDelete;
import org.basex.query.up.primitives.db.DBStore;
import org.basex.query.up.primitives.node.DeleteNode;
import org.basex.query.up.primitives.node.ReplaceDoc;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.options.Options;

public final class DbReplace
extends DbNew {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        boolean disk;
        Data data = this.checkData(qc);
        String path = this.path(1, qc);
        Item item = this.toNodeOrAtomItem(2, qc);
        Options opts = this.toOptions(3, new Options(), qc);
        Updates updates = qc.updates();
        IntList docs = data.resources.docs(path);
        int d = 0;
        IOFile bin = data.meta.binary(path);
        boolean bl = disk = !data.inMemory();
        if (disk && (bin == null || bin.isDir())) {
            throw QueryError.DB_TARGET_X.get(this.info, path);
        }
        if (disk && item instanceof Bin) {
            updates.add(new DBStore(data, path, item, this.info), qc);
        } else {
            if (disk && bin.exists()) {
                updates.add(new DBDelete(data, path, this.info), qc);
            }
            NewInput input = this.checkInput(item, Token.token(path));
            if (docs.isEmpty()) {
                updates.add(new DBAdd(data, input, opts, true, qc, this.info), qc);
            } else {
                updates.add(new ReplaceDoc(docs.get(d++), data, input, opts, qc, this.info), qc);
            }
        }
        int ds = docs.size();
        while (d < ds) {
            updates.add(new DeleteNode(docs.get(d), data, this.info), qc);
            ++d;
        }
        return null;
    }
}

