/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbList;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.DateTime;
import org.basex.util.Token;
import org.basex.util.http.MediaType;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class DbListDetails
extends DbList {
    private static final String DATABASE = "database";
    private static final String RESOURCE = "resource";
    private static final String RESOURCES = "resources";
    private static final String PATH = "path";
    private static final String RAW = "raw";
    private static final String SIZE = "size";
    private static final String CTYPE = "content-type";
    private static final String MDATE = "modified-date";

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.exprs.length == 0 ? DbListDetails.list(qc) : this.resources(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc);
    }

    private static Iter list(QueryContext qc) {
        final Context ctx = qc.context;
        final StringList dbs = ctx.listDBs();
        return new BasicIter<FNode>((long)dbs.size()){

            @Override
            public FElem get(long i) {
                String name = (String)dbs.get((int)i);
                FElem database = new FElem(DbListDetails.DATABASE);
                MetaData meta = new MetaData(name, ctx.options, ctx.soptions);
                try {
                    meta.read();
                    int bin = new IOFile(ctx.soptions.dbPath(name), DbListDetails.RAW).descendants().size();
                    database.add(DbListDetails.RESOURCES, Token.token(meta.ndocs + bin));
                    database.add(DbListDetails.MDATE, DateTime.format(new Date(meta.dbtime())));
                    database.add(DbListDetails.SIZE, Token.token(meta.dbsize()));
                    if (ctx.perm(Perm.CREATE, name)) {
                        database.add(DbListDetails.PATH, meta.original);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return database.add(name);
            }
        };
    }

    private Iter resources(QueryContext qc) throws QueryException {
        final Data data = this.checkData(qc);
        String path = Token.string(this.exprs.length == 1 ? Token.EMPTY : this.toToken(this.exprs[1], qc));
        final IntList docs = data.resources.docs(path);
        final TokenList bins = data.resources.binaries(path);
        final int ds = docs.size();
        int size = ds + bins.size();
        return new BasicIter<FNode>((long)size){

            @Override
            public FNode get(long i) {
                if (i < (long)ds) {
                    int pre = docs.get((int)i);
                    byte[] pt = data.text(pre, true);
                    int sz = data.size(pre, 0);
                    return DbListDetails.resource(pt, false, sz, MediaType.APPLICATION_XML, data.meta.time);
                }
                if (i < this.size) {
                    byte[] pt = (byte[])bins.get((int)i - ds);
                    IOFile io = data.meta.binary(Token.string(pt));
                    return DbListDetails.resource(pt, true, io.length(), MediaType.get(io.path()), io.timeStamp());
                }
                return null;
            }
        };
    }

    private static FNode resource(byte[] path, boolean raw, long size, MediaType type, long mdate) {
        return new FElem(RESOURCE).add(path).add(RAW, Token.token(raw)).add(CTYPE, type.toString()).add(MDATE, DateTime.format(new Date(mdate))).add(SIZE, Token.token(size));
    }
}

