/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.basex.core.users.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaFunc;
import org.basex.query.func.JavaMapping;
import org.basex.query.func.JavaModuleFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.pkg.ModuleLoader;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class JavaFunction
extends Arr {
    static final String NEW = "new";
    final StaticContext sc;
    final Perm perm;

    JavaFunction(StaticContext sc, InputInfo info, Expr[] args, Perm perm) {
        super(info, SeqType.ITEM_ZM, args);
        this.sc = sc;
        this.perm = perm;
    }

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        if (!qc.context.user().has(this.perm)) {
            throw QueryError.BASEX_PERMISSION_X_X.get(this.info, new Object[]{this.perm, this});
        }
        int es = this.exprs.length;
        Value[] args = new Value[es];
        for (int e = 0; e < es; ++e) {
            args[e] = this.exprs[e].value(qc);
        }
        return JavaFunction.toValue(this.eval(args, qc), qc, this.sc);
    }

    protected abstract Object eval(Value[] var1, QueryContext var2) throws QueryException;

    @Override
    public boolean has(Flag ... flags) {
        return Flag.NDT.in(flags) || super.has(flags);
    }

    public static Value toValue(Object object, QueryContext qc, StaticContext sc) throws QueryException {
        if (object == null) {
            return Empty.SEQ;
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Iter) {
            return ((Iter)object).value(qc);
        }
        Type type = JavaFunction.type(object);
        if (type != null) {
            return type.cast(object, qc, sc, null);
        }
        if (object instanceof byte[]) {
            return BytSeq.get((byte[])object);
        }
        if (object instanceof long[]) {
            return IntSeq.get((long[])object, AtomType.ITR);
        }
        if (object instanceof char[]) {
            return Str.get(new String((char[])object));
        }
        if (object instanceof boolean[]) {
            return BlnSeq.get((boolean[])object);
        }
        if (object instanceof double[]) {
            return DblSeq.get((double[])object);
        }
        if (object instanceof float[]) {
            return FltSeq.get((float[])object);
        }
        if (!object.getClass().isArray()) {
            return new Jav(object, qc);
        }
        int s = Array.getLength(object);
        if (s == 0) {
            return Empty.SEQ;
        }
        if (object instanceof String[]) {
            String[] r = (String[])object;
            byte[][] b = new byte[r.length][];
            for (int v = 0; v < s; ++v) {
                b[v] = Token.token(r[v]);
            }
            return StrSeq.get(b);
        }
        if (object instanceof char[][]) {
            char[][] r = (char[][])object;
            byte[][] b = new byte[r.length][];
            for (int v = 0; v < s; ++v) {
                b[v] = Token.token(new String(r[v]));
            }
            return StrSeq.get(b);
        }
        if (object instanceof short[]) {
            short[] r = (short[])object;
            long[] b = new long[r.length];
            for (int v = 0; v < s; ++v) {
                b[v] = r[v];
            }
            return IntSeq.get(b, AtomType.SHR);
        }
        if (object instanceof int[]) {
            int[] r = (int[])object;
            long[] b = new long[r.length];
            for (int v = 0; v < s; ++v) {
                b[v] = r[v];
            }
            return IntSeq.get(b, AtomType.INT);
        }
        Object[] objects = (Object[])object;
        ValueBuilder vb = new ValueBuilder(qc);
        for (Object obj : objects) {
            vb.add(JavaFunction.toValue(obj, qc, sc));
        }
        return vb.value();
    }

    static JavaFunction get(QNm qname, Expr[] args, QueryContext qc, StaticContext sc, InputInfo info) throws QueryException {
        String uri;
        boolean java;
        String name = Strings.camelCase(Token.string(qname.local()));
        String[] types = null;
        int n = name.indexOf(183);
        if (n != -1) {
            types = Strings.split(name.substring(n + 1), '\u00b7');
            name = name.substring(0, n);
        }
        String className = (java = (uri = Token.string(qname.uri())).startsWith("java:")) ? uri.substring("java:".length()) : Strings.className(Strings.uri2path(uri));
        ModuleLoader modules = qc.resources.modules();
        Object module = modules.findModule(className);
        if (module != null) {
            Method meth = JavaFunction.moduleMethod(module, name, args.length, types, qc, info);
            QueryModule.Requires req = meth.getAnnotation(QueryModule.Requires.class);
            Perm perm = req == null ? Perm.ADMIN : Perm.get(req.value().name().toLowerCase(Locale.ENGLISH));
            return new JavaModuleFunc(sc, info, module, meth, args, perm);
        }
        boolean clz = false;
        try {
            Class<?> clazz = modules.findClass(className);
            clz = true;
            if (name.equals(NEW) || JavaFunction.exists(clazz, name)) {
                return new JavaFunc(sc, info, clazz, name, types, args);
            }
        }
        catch (ClassNotFoundException ex) {
            if (java) {
                Util.debug(ex);
            }
        }
        catch (Throwable th) {
            throw QueryError.JAVAINIT_X_X.get(info, Util.className(th), th);
        }
        if (java) {
            throw (clz ? QueryError.WHICHJAVA_X_X_X : QueryError.WHICHCLASS_X).get(info, className, name, args.length);
        }
        return null;
    }

    private static Method moduleMethod(Object module, String name, int arity, String[] types, QueryContext qc, InputInfo info) throws QueryException {
        Method meth = null;
        int methArity = -1;
        Class<?> clazz = module.getClass();
        for (Method m : clazz.getMethods()) {
            Class<?>[] pTypes;
            if (!m.getName().equals(name) || (methArity = (pTypes = m.getParameterTypes()).length) != arity) continue;
            methArity = -1;
            if (!JavaFunction.typeMatches(pTypes, types)) continue;
            if (meth != null) {
                throw QueryError.JAVAAMB_X_X_X.get(info, clazz.getName(), name, arity);
            }
            meth = m;
        }
        if (meth == null) {
            if (methArity != -1) {
                throw QueryError.JAVAARITY_X_X_X_X.get(info, clazz.getName(), name, methArity, QueryError.arguments(arity));
            }
            throw QueryError.WHICHJAVA_X_X_X.get(info, clazz.getName(), name, arity);
        }
        QueryModule.Lock lock = meth.getAnnotation(QueryModule.Lock.class);
        if (lock != null) {
            for (String read : lock.read()) {
                qc.readLocks.add("&" + read);
            }
            for (String write : lock.write()) {
                qc.writeLocks.add("&" + write);
            }
        }
        return meth;
    }

    protected static boolean typeMatches(Class<?>[] pTypes, String[] qTypes) {
        if (qTypes == null) {
            return true;
        }
        int pl = pTypes.length;
        if (pl != qTypes.length) {
            return false;
        }
        for (int p = 0; p < pl; ++p) {
            if (qTypes[p].equals(pTypes[p].getName())) continue;
            return false;
        }
        return true;
    }

    private static boolean exists(Class<?> clazz, String name) {
        int tp = name.indexOf(183);
        String nm = tp == -1 ? name : name.substring(0, tp);
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(nm)) continue;
            return true;
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (!((Method)accessibleObject).getName().equals(nm)) continue;
            return true;
        }
        return false;
    }

    private static Type type(Object object) {
        Type type = JavaMapping.type(object.getClass(), true);
        if (type != null) {
            return type;
        }
        if (object instanceof Element) {
            return NodeType.ELM;
        }
        if (object instanceof Document) {
            return NodeType.DOC;
        }
        if (object instanceof DocumentFragment) {
            return NodeType.DOC;
        }
        if (object instanceof Attr) {
            return NodeType.ATT;
        }
        if (object instanceof Comment) {
            return NodeType.COM;
        }
        if (object instanceof ProcessingInstruction) {
            return NodeType.PI;
        }
        if (object instanceof Text) {
            return NodeType.TXT;
        }
        if (object instanceof Duration) {
            Duration d = (Duration)object;
            return !d.isSet(DatatypeConstants.YEARS) && !d.isSet(DatatypeConstants.MONTHS) ? AtomType.DTD : (!d.isSet(DatatypeConstants.HOURS) && !d.isSet(DatatypeConstants.MINUTES) && !d.isSet(DatatypeConstants.SECONDS) ? AtomType.YMD : AtomType.DUR);
        }
        if (object instanceof XMLGregorianCalendar) {
            QName qnm = ((XMLGregorianCalendar)object).getXMLSchemaType();
            if (qnm == DatatypeConstants.DATE) {
                return AtomType.DAT;
            }
            if (qnm == DatatypeConstants.DATETIME) {
                return AtomType.DTM;
            }
            if (qnm == DatatypeConstants.TIME) {
                return AtomType.TIM;
            }
            if (qnm == DatatypeConstants.GYEARMONTH) {
                return AtomType.YMO;
            }
            if (qnm == DatatypeConstants.GMONTHDAY) {
                return AtomType.MDA;
            }
            if (qnm == DatatypeConstants.GYEAR) {
                return AtomType.YEA;
            }
            if (qnm == DatatypeConstants.GMONTH) {
                return AtomType.MON;
            }
            if (qnm == DatatypeConstants.GDAY) {
                return AtomType.DAY;
            }
        }
        return null;
    }

    protected static String foundArgs(Value[] args) {
        StringBuilder sb = new StringBuilder();
        for (Value arg : args) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(arg instanceof Jav ? Util.className(((Jav)arg).toJava()) : arg.seqType());
        }
        return sb.toString();
    }

    protected static Object[] javaArgs(Class<?>[] pTypes, boolean[] vTypes, Value[] args, boolean stat) throws QueryException {
        int pl = pTypes.length;
        int s = stat ? 0 : 1;
        if (pl != args.length - s) {
            return null;
        }
        boolean[] vType = vTypes == null ? JavaFunction.values(pTypes) : vTypes;
        Object[] vals = new Object[pl];
        for (int p = 0; p < pl; ++p) {
            Class<?> param = pTypes[p];
            Value arg = args[s + p];
            if (arg.type.instanceOf(JavaMapping.type(param, true))) {
                vals[p] = arg.toJava();
                continue;
            }
            Object object = vals[p] = arg instanceof Jav || !vType[p] ? arg.toJava() : arg;
            if (param.isInstance(vals[p])) continue;
            if (arg.isEmpty() && !param.isPrimitive()) {
                vals[p] = null;
                continue;
            }
            return null;
        }
        return vals;
    }

    protected static boolean[] values(Class<?>[] params) {
        int l = params.length;
        boolean[] vals = new boolean[l];
        for (int a = 0; a < l; ++a) {
            vals[a] = Value.class.isAssignableFrom(params[a]);
        }
        return vals;
    }
}

