/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ft.FTAnd;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTNot;
import org.basex.query.iter.FTIter;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTMatches;
import org.basex.query.value.node.FTNode;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.IntObjMap;

public final class FTOr
extends FTExpr {
    public FTOr(InputInfo info, FTExpr[] exprs) {
        super(info, exprs);
    }

    @Override
    public FTExpr compile(CompileContext cc) throws QueryException {
        super.compile(cc);
        boolean not = true;
        for (FTExpr expr : this.exprs) {
            not &= expr instanceof FTNot;
        }
        if (not) {
            int es = this.exprs.length;
            for (int e = 0; e < es; ++e) {
                this.exprs[e] = this.exprs[e].exprs[0];
            }
            return (FTExpr)cc.replaceWith(this, new FTNot(this.info, (FTExpr)new FTAnd(this.info, this.exprs)));
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext qc, InputInfo ii) throws QueryException {
        FTNode item = this.exprs[0].item(qc, this.info);
        int es = this.exprs.length;
        for (int e = 1; e < es; ++e) {
            FTOr.or(item, this.exprs[e].item(qc, this.info));
        }
        return item;
    }

    @Override
    public FTIter iter(QueryContext qc) throws QueryException {
        final int es = this.exprs.length;
        final FTIter[] ters = new FTIter[es];
        final FTNode[] nodes = new FTNode[es];
        for (int e = 0; e < es; ++e) {
            ters[e] = this.exprs[e].iter(qc);
            nodes[e] = ters[e].next();
        }
        return new FTIter(){

            @Override
            public FTNode next() throws QueryException {
                int p = -1;
                for (int i = 0; i < es; ++i) {
                    if (nodes[i] == null || p != -1 && nodes[p].pre() <= nodes[i].pre()) continue;
                    p = i;
                }
                if (p == -1) {
                    return null;
                }
                FTNode item = nodes[p];
                for (int i = 0; i < es; ++i) {
                    if (nodes[i] == null || p == i || item.pre() != nodes[i].pre()) continue;
                    FTOr.or(item, nodes[i]);
                    nodes[i] = ters[i].next();
                }
                nodes[p] = ters[p].next();
                return item;
            }
        };
    }

    private static void or(FTNode i1, FTNode i2) {
        FTMatches all1 = i1.matches();
        FTMatches all2 = i2.matches();
        FTMatches all = new FTMatches((byte)Math.max(all1.pos, all2.pos));
        for (FTMatch m : all1) {
            all.add(m);
        }
        for (FTMatch m : all2) {
            all.add(m);
        }
        i1.score(Scoring.avg(i1.score() + i2.score(), 2));
        i1.matches(all);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        IndexCosts costs = IndexCosts.ZERO;
        for (FTExpr expr : this.exprs) {
            if (!expr.indexAccessible(ii)) {
                return false;
            }
            costs = IndexCosts.add(costs, ii.costs);
        }
        ii.costs = costs;
        return true;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTOr(this.info, (FTExpr[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.exprs));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FTOr && super.equals(obj);
    }

    @Override
    public String toString() {
        return "(" + this.toString(" ftor ") + ")";
    }
}

